package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.System;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top level system data containers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-top {
 *   container system {
 *     container config {
 *       uses system-global-config;
 *     }
 *     container state {
 *       config false;
 *       uses system-global-config;
 *       uses system-global-state;
 *     }
 *     uses system-clock-top;
 *     uses system-dns-top;
 *     uses system-ntp-top;
 *     uses oc-sys-term:system-ssh-server-top;
 *     uses oc-sys-term:system-telnet-server-top;
 *     uses oc-log:logging-top;
 *     uses oc-aaa:aaa-top;
 *     uses system-memory-top;
 *     uses system-cpu-top;
 *     uses oc-proc:procmon-processes-top;
 *     uses oc-alarms:alarms-top;
 *     uses oc-messages:messages-top;
 *     uses oc-license:license-top;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-systemsystem-top</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-top");

    @Override
    Class<? extends SystemTop> implementedInterface();
    
    /**
     * Return system, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for system-related configuration and operational state data
     *     </code>
     * </pre>
     *
     * @return {@code System} system, or {@code null} if it is not present.
     *
     */
    System getSystem();

}

