package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for system-wide NTP operation.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-ntp-state {
 *   leaf auth-mismatch {
 *     type oc-yang:counter64;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-systemsystem-ntp-state</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemNtpState
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-ntp-state");

    @Override
    Class<? extends SystemNtpState> implementedInterface();
    
    /**
     * Return authMismatch, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Count of the number of NTP packets received that were not processed due to
     *         authentication mismatch.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} authMismatch, or {@code null} if it is not present.
     *
     */
    Counter64 getAuthMismatch();
    
    /**
     * Return authMismatch, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Count of the number of NTP packets received that were not processed due to
     *         authentication mismatch.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} authMismatch, guaranteed to be non-null.
     * @throws NoSuchElementException if authMismatch is not present
     *
     */
    default @NonNull Counter64 requireAuthMismatch() {
        return CodeHelpers.require(getAuthMismatch(), "authmismatch");
    }

}

