package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv4Address;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv6Address;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for static host entries
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-dns-static-config {
 *   leaf hostname {
 *     type string;
 *   }
 *   leaf-list alias {
 *     type string;
 *   }
 *   leaf-list ipv4-address {
 *     type oc-inet:ipv4-address;
 *   }
 *   leaf-list ipv6-address {
 *     type oc-inet:ipv6-address;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-systemsystem-dns-static-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemDnsStaticConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-dns-static-config");

    @Override
    Class<? extends SystemDnsStaticConfig> implementedInterface();
    
    /**
     * Return hostname, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Hostname for the static DNS entry
     *     </code>
     * </pre>
     *
     * @return {@code String} hostname, or {@code null} if it is not present.
     *
     */
    String getHostname();
    
    /**
     * Return hostname, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Hostname for the static DNS entry
     *     </code>
     * </pre>
     *
     * @return {@code String} hostname, guaranteed to be non-null.
     * @throws NoSuchElementException if hostname is not present
     *
     */
    default @NonNull String requireHostname() {
        return CodeHelpers.require(getHostname(), "hostname");
    }
    
    /**
     * Return alias, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Additional aliases for the hostname
     *     </code>
     * </pre>
     *
     * @return {@code List<String>} alias, or {@code null} if it is not present.
     *
     */
    @Nullable List<String> getAlias();
    
    /**
     * Return alias, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Additional aliases for the hostname
     *     </code>
     * </pre>
     *
     * @return {@code List<String>} alias, guaranteed to be non-null.
     * @throws NoSuchElementException if alias is not present
     *
     */
    default @NonNull List<String> requireAlias() {
        return CodeHelpers.require(getAlias(), "alias");
    }
    
    /**
     * Return ipv4Address, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of IPv4 addresses for the host entry
     *     </code>
     * </pre>
     *
     * @return {@code List<Ipv4Address>} ipv4Address, or {@code null} if it is not present.
     *
     */
    @Nullable List<Ipv4Address> getIpv4Address();
    
    /**
     * Return ipv4Address, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         List of IPv4 addresses for the host entry
     *     </code>
     * </pre>
     *
     * @return {@code List<Ipv4Address>} ipv4Address, guaranteed to be non-null.
     * @throws NoSuchElementException if ipv4Address is not present
     *
     */
    default @NonNull List<Ipv4Address> requireIpv4Address() {
        return CodeHelpers.require(getIpv4Address(), "ipv4address");
    }
    
    /**
     * Return ipv6Address, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of IPv6 addresses for the host entry
     *     </code>
     * </pre>
     *
     * @return {@code List<Ipv6Address>} ipv6Address, or {@code null} if it is not present.
     *
     */
    @Nullable List<Ipv6Address> getIpv6Address();
    
    /**
     * Return ipv6Address, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         List of IPv6 addresses for the host entry
     *     </code>
     * </pre>
     *
     * @return {@code List<Ipv6Address>} ipv6Address, guaranteed to be non-null.
     * @throws NoSuchElementException if ipv6Address is not present
     *
     */
    default @NonNull List<Ipv6Address> requireIpv6Address() {
        return CodeHelpers.require(getIpv6Address(), "ipv6address");
    }

}

