package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.io.Serializable;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.HardwareInterrupt;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Idle;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Kernel;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Nice;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.SoftwareInterrupt;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Total;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.User;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Wait;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Operational state data for the system CPU(s)
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-cpu-state {
 *   leaf index {
 *     type union {
 *       type enumeration {
 *         enum ALL {
 *         }
 *       }
 *       type uint32;
 *     }
 *   }
 *   container total {
 *     uses oc-types:avg-min-max-instant-stats-pct;
 *   }
 *   container user {
 *     uses oc-types:avg-min-max-instant-stats-pct;
 *   }
 *   container kernel {
 *     uses oc-types:avg-min-max-instant-stats-pct;
 *   }
 *   container nice {
 *     uses oc-types:avg-min-max-instant-stats-pct;
 *   }
 *   container idle {
 *     uses oc-types:avg-min-max-instant-stats-pct;
 *   }
 *   container wait {
 *     uses oc-types:avg-min-max-instant-stats-pct;
 *   }
 *   container hardware-interrupt {
 *     uses oc-types:avg-min-max-instant-stats-pct;
 *   }
 *   container software-interrupt {
 *     uses oc-types:avg-min-max-instant-stats-pct;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-systemsystem-cpu-state</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemCpuState
    extends
    DataObject
{

    public static final class Index
     implements TypeObject, Serializable {
        private static final long serialVersionUID = 8590796611830327483L;
        @Generated("mdsal-binding-generator")
        public enum Enumeration implements org.opendaylight.yangtools.yang.binding.Enumeration {
            /**
             * Index value indicating all CPUs in the system
             */
            ALL(0, "ALL")
            ;
        
            private static final Map<String, Enumeration> NAME_MAP;
            private static final Map<Integer, Enumeration> VALUE_MAP;
        
            static {
                final Builder<String, Enumeration> nb = ImmutableMap.builder();
                final Builder<Integer, Enumeration> vb = ImmutableMap.builder();
                for (Enumeration enumItem : Enumeration.values()) {
                    vb.put(enumItem.value, enumItem);
                    nb.put(enumItem.name, enumItem);
                }
        
                NAME_MAP = nb.build();
                VALUE_MAP = vb.build();
            }
        
            private final String name;
            private final int value;
        
            private Enumeration(int value, String name) {
                this.value = value;
                this.name = name;
            }
        
            @Override
            public String getName() {
                return name;
            }
        
            @Override
            public int getIntValue() {
                return value;
            }
        
            /**
             * Return the enumeration member whose {@link #getName()} matches specified value.
             *
             * @param name YANG assigned name
             * @return corresponding Enumeration item, if present
             * @throws NullPointerException if name is null
             */
            public static Optional<Enumeration> forName(String name) {
                return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
            }
        
            /**
             * Return the enumeration member whose {@link #getIntValue()} matches specified value.
             *
             * @param intValue integer value
             * @return corresponding Enumeration item, or null if no such item exists
             */
            public static Enumeration forValue(int intValue) {
                return VALUE_MAP.get(intValue);
            }
        }
        private final Enumeration _enumeration;
        private final Uint32 _uint32;
    
    
        public Index(Enumeration _enumeration) {
            super();
            this._enumeration = _enumeration;
            this._uint32 = null;
        }
        
        public Index(Uint32 _uint32) {
            super();
            this._uint32 = _uint32;
            this._enumeration = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Index(Index source) {
            this._enumeration = source._enumeration;
            this._uint32 = source._uint32;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_enumeration != null) {
                return _enumeration.toString();
            }
            if (_uint32 != null) {
                return _uint32.toCanonicalString();
            }
        
            throw new IllegalStateException("No value assinged");
        }
    
    
        public Enumeration getEnumeration() {
            return _enumeration;
        }
        
        public Uint32 getUint32() {
            return _uint32;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_enumeration);
            result = prime * result + Objects.hashCode(_uint32);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Index)) {
                return false;
            }
            final Index other = (Index) obj;
            if (!Objects.equals(_enumeration, other._enumeration)) {
                return false;
            }
            if (!Objects.equals(_uint32, other._uint32)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(Index.class);
            CodeHelpers.appendValue(helper, "_enumeration", _enumeration);
            CodeHelpers.appendValue(helper, "_uint32", _uint32);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-cpu-state");

    @Override
    Class<? extends SystemCpuState> implementedInterface();
    
    /**
     * Return index, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The CPU index for each processor core on the system. On a single-core system,
     *         the index should be zero. The ALL index signifies an aggregation of the CPU
     *         utilization statistics over all cores in the system.
     *     </code>
     * </pre>
     *
     * @return {@code Index} index, or {@code null} if it is not present.
     *
     */
    Index getIndex();
    
    /**
     * Return index, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The CPU index for each processor core on the system. On a single-core system,
     *         the index should be zero. The ALL index signifies an aggregation of the CPU
     *         utilization statistics over all cores in the system.
     *     </code>
     * </pre>
     *
     * @return {@code Index} index, guaranteed to be non-null.
     * @throws NoSuchElementException if index is not present
     *
     */
    default @NonNull Index requireIndex() {
        return CodeHelpers.require(getIndex(), "index");
    }
    
    /**
     * Return total, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Total CPU utilization.
     *     </code>
     * </pre>
     *
     * @return {@code Total} total, or {@code null} if it is not present.
     *
     */
    Total getTotal();
    
    /**
     * Return user, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Percentage of CPU time spent running in user space.
     *     </code>
     * </pre>
     *
     * @return {@code User} user, or {@code null} if it is not present.
     *
     */
    User getUser();
    
    /**
     * Return kernel, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Percentage of CPU time spent running in kernel space.
     *     </code>
     * </pre>
     *
     * @return {@code Kernel} kernel, or {@code null} if it is not present.
     *
     */
    Kernel getKernel();
    
    /**
     * Return nice, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Percentage of CPU time spent running low-priority (niced) user processes.
     *     </code>
     * </pre>
     *
     * @return {@code Nice} nice, or {@code null} if it is not present.
     *
     */
    Nice getNice();
    
    /**
     * Return idle, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Percentage of CPU time spent idle.
     *     </code>
     * </pre>
     *
     * @return {@code Idle} idle, or {@code null} if it is not present.
     *
     */
    Idle getIdle();
    
    /**
     * Return wait, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Percentage of CPU time spent waiting for I/O.
     *     </code>
     * </pre>
     *
     * @return {@code Wait} wait, or {@code null} if it is not present.
     *
     */
    Wait getWait();
    
    /**
     * Return hardwareInterrupt, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Percentage of CPU time spent servicing hardware interrupts.
     *     </code>
     * </pre>
     *
     * @return {@code HardwareInterrupt} hardwareInterrupt, or {@code null} if it is not present.
     *
     */
    HardwareInterrupt getHardwareInterrupt();
    
    /**
     * Return softwareInterrupt, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Percentage of CPU time spent servicing software interrupts
     *     </code>
     * </pre>
     *
     * @return {@code SoftwareInterrupt} softwareInterrupt, or {@code null} if it is not present.
     *
     */
    SoftwareInterrupt getSoftwareInterrupt();

}

