package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum SyslogSeverity implements Enumeration {
    /**
     * Emergency: system is unusable (0)
     */
    EMERGENCY(0, "EMERGENCY"),
    
    /**
     * Alert: action must be taken immediately (1)
     */
    ALERT(1, "ALERT"),
    
    /**
     * Critical: critical conditions (2)
     */
    CRITICAL(2, "CRITICAL"),
    
    /**
     * Error: error conditions (3)
     */
    ERROR(3, "ERROR"),
    
    /**
     * Warning: warning conditions (4)
     */
    WARNING(4, "WARNING"),
    
    /**
     * Notice: normal but significant  condition(5)
     */
    NOTICE(5, "NOTICE"),
    
    /**
     * Informational: informational messages (6)
     */
    INFORMATIONAL(6, "INFORMATIONAL"),
    
    /**
     * Debug: debug-level messages (7)
     */
    DEBUG(7, "DEBUG")
    ;

    private static final Map<String, SyslogSeverity> NAME_MAP;
    private static final Map<Integer, SyslogSeverity> VALUE_MAP;

    static {
        final Builder<String, SyslogSeverity> nb = ImmutableMap.builder();
        final Builder<Integer, SyslogSeverity> vb = ImmutableMap.builder();
        for (SyslogSeverity enumItem : SyslogSeverity.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private SyslogSeverity(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding SyslogSeverity item, if present
     * @throws NullPointerException if name is null
     */
    public static Optional<SyslogSeverity> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding SyslogSeverity item, or null if no such item exists
     */
    public static SyslogSeverity forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
