package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentTempAlarmState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentTempState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118.AvgMinMaxInstantStatsPrecision1Celsius;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Temperature in degrees Celsius of the component. Values include the 
 * instantaneous, average, minimum, and maximum statistics. If avg/min/max 
 * statistics are not supported, the target is expected to just supply the instant 
 * value
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * container temperature {
 *   uses oc-platform-types:avg-min-max-instant-stats-precision1-celsius;
 *   uses platform-component-temp-alarm-state;
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-platformplatform-component-temp-statetemperature</i>
 *
 * <p>To create instances of this class use {@link TemperatureBuilder}.
 * @see TemperatureBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Temperature
    extends
    ChildOf<PlatformComponentTempState>,
    Augmentable<Temperature>,
    AvgMinMaxInstantStatsPrecision1Celsius,
    PlatformComponentTempAlarmState
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("temperature");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state.Temperature> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state.Temperature.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state.@NonNull Temperature obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAlarmSeverity());
        result = prime * result + Objects.hashCode(obj.getAlarmStatus());
        result = prime * result + Objects.hashCode(obj.getAlarmThreshold());
        result = prime * result + Objects.hashCode(obj.getAvg());
        result = prime * result + Objects.hashCode(obj.getInstant());
        result = prime * result + Objects.hashCode(obj.getInterval());
        result = prime * result + Objects.hashCode(obj.getMax());
        result = prime * result + Objects.hashCode(obj.getMaxTime());
        result = prime * result + Objects.hashCode(obj.getMin());
        result = prime * result + Objects.hashCode(obj.getMinTime());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state.@NonNull Temperature thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state.Temperature other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state.Temperature.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAlarmSeverity(), other.getAlarmSeverity())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAlarmStatus(), other.getAlarmStatus())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAlarmThreshold(), other.getAlarmThreshold())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAvg(), other.getAvg())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInstant(), other.getInstant())) {
            return false;
        }
        if (!Objects.equals(thisObj.getInterval(), other.getInterval())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMax(), other.getMax())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaxTime(), other.getMaxTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMin(), other.getMin())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMinTime(), other.getMinTime())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state.@NonNull Temperature obj) {
        final var helper = MoreObjects.toStringHelper("Temperature");
        CodeHelpers.appendValue(helper, "alarmSeverity", obj.getAlarmSeverity());
        CodeHelpers.appendValue(helper, "alarmStatus", obj.getAlarmStatus());
        CodeHelpers.appendValue(helper, "alarmThreshold", obj.getAlarmThreshold());
        CodeHelpers.appendValue(helper, "avg", obj.getAvg());
        CodeHelpers.appendValue(helper, "instant", obj.getInstant());
        CodeHelpers.appendValue(helper, "interval", obj.getInterval());
        CodeHelpers.appendValue(helper, "max", obj.getMax());
        CodeHelpers.appendValue(helper, "maxTime", obj.getMaxTime());
        CodeHelpers.appendValue(helper, "min", obj.getMin());
        CodeHelpers.appendValue(helper, "minTime", obj.getMinTime());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

