package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.Components;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for components in the device inventory
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * grouping platform-component-top {
 *   container components {
 *     list component {
 *       key name;
 *       leaf name {
 *         type leafref {
 *           path ../config/name;
 *         }
 *       }
 *       container config {
 *         uses platform-component-config;
 *       }
 *       container state {
 *         config false;
 *         uses platform-component-config;
 *         uses platform-component-state;
 *         uses platform-component-temp-state;
 *         uses platform-component-memory-state;
 *         uses platform-component-power-state;
 *       }
 *       uses platform-component-properties-top;
 *       uses platform-subcomponent-ref-top;
 *       uses platform-anchors-top;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-platformplatform-component-top</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface PlatformComponentTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("platform-component-top");

    @Override
    Class<? extends PlatformComponentTop> implementedInterface();
    
    /**
     * Return components, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for the components in the system.
     *     </code>
     * </pre>
     *
     * @return {@code Components} components, or {@code null} if it is not present.
     *
     */
    Components getComponents();

}

