package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Power-related operational state for device components.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * grouping platform-component-power-state {
 *   leaf allocated-power {
 *     type uint32;
 *     units watts;
 *   }
 *   leaf used-power {
 *     type uint32;
 *     units watts;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-platformplatform-component-power-state</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface PlatformComponentPowerState
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("platform-component-power-state");

    @Override
    Class<? extends PlatformComponentPowerState> implementedInterface();
    
    /**
     * Return allocatedPower, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Power allocated by the system for the component.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} allocatedPower, or {@code null} if it is not present.
     *
     */
    Uint32 getAllocatedPower();
    
    /**
     * Return allocatedPower, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Power allocated by the system for the component.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} allocatedPower, guaranteed to be non-null.
     * @throws NoSuchElementException if allocatedPower is not present
     *
     */
    default @NonNull Uint32 requireAllocatedPower() {
        return CodeHelpers.require(getAllocatedPower(), "allocatedpower");
    }
    
    /**
     * Return usedPower, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Actual power used by the component.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} usedPower, or {@code null} if it is not present.
     *
     */
    Uint32 getUsedPower();
    
    /**
     * Return usedPower, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Actual power used by the component.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} usedPower, guaranteed to be non-null.
     * @throws NoSuchElementException if usedPower is not present
     *
     */
    default @NonNull Uint32 requireUsedPower() {
        return CodeHelpers.require(getUsedPower(), "usedpower");
    }

}

