package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module defines a data model for representing a system component inventory, 
 * which can include hardware or software elements arranged in an arbitrary 
 * structure. The primary relationship supported by the model is containment, 
 * components containing subcomponents. It is expected that this model reflects 
 * every field replacable unit on the device at a minimum (i.e., additional 
 * information may be supplied about non-replacable components). Every element in 
 * the inventory is termed a 'component' with each component expected to have a 
 * unique name and type, and optionally a unique system-assigned identifier and 
 * number. The uniqueness is guaranteed by the system within the device. 
 * may have properties defined by the system that are modeled as a list of 
 * key-value pairs. These may or may not be user-configurable. The model provides 
 * flag for the system to optionally indicate which properties are user 
 * configurable. Each component also has a list of 'subcomponents' which are 
 * references to other components. Appearance in a list of subcomponents indicates 
 * a containment relationship as described above. For example, a linecard 
 * may have a list of references to port components that reside on the linecard. 
 * This schema is generic to allow devices to express their own platform-specific 
 * structure. It may be augmented by additional component type-specific schemas 
 * that provide a common structure for well-known component types. In these cases, 
 * the system is expected to populate the common component schema, and may 
 * optionally also represent the component and its properties in the generic 
 * structure. The properties for each component may include dynamic values, e.g., 
 * in the 'state' part of the schema. For example, a CPU component may report its 
 * utilization, temperature, or other physical properties. The intent is to 
 * all platform- specific physical data in one location, including inventory 
 * (presence or absence of a component) and state (physical attributes or status).
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * module openconfig-platform {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/platform";
 *   prefix oc-platform;
 *   import openconfig-platform-types {
 *     prefix oc-platform-types;
 *   }
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   import openconfig-alarm-types {
 *     prefix oc-alarm-types;
 *   }
 *   import openconfig-yang-types {
 *     prefix oc-yang;
 *   }
 *   oc-ext:openconfig-version 0.13.0;
 *   revision 2021-01-18 {
 *   }
 *   revision 2019-04-16 {
 *   }
 *   revision 2018-11-21 {
 *   }
 *   revision 2018-06-29 {
 *   }
 *   revision 2018-06-03 {
 *   }
 *   revision 2018-04-20 {
 *   }
 *   revision 2018-01-30 {
 *   }
 *   revision 2018-01-16 {
 *   }
 *   revision 2017-12-14 {
 *   }
 *   revision 2017-08-16 {
 *   }
 *   revision 2016-12-22 {
 *   }
 *   oc-ext:regexp-posix;
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   grouping platform-component-properties-config {
 *     leaf name {
 *       type string;
 *     }
 *     leaf value {
 *       type union {
 *         type string;
 *         type boolean;
 *         type int64;
 *         type uint64;
 *         type decimal64 {
 *           fraction-digits 2;
 *         }
 *       }
 *     }
 *   }
 *   grouping platform-component-properties-state {
 *     leaf configurable {
 *       type boolean;
 *     }
 *   }
 *   grouping platform-component-properties-top {
 *     container properties {
 *       list property {
 *         key name;
 *         leaf name {
 *           type leafref {
 *             path ../config/name;
 *           }
 *         }
 *         container config {
 *           uses platform-component-properties-config;
 *         }
 *         container state {
 *           config false;
 *           uses platform-component-properties-config;
 *           uses platform-component-properties-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping platform-subcomponent-ref-config {
 *     leaf name {
 *       type leafref {
 *         path ../../../../../component/config/name;
 *       }
 *     }
 *   }
 *   grouping platform-subcomponent-ref-state {
 *   }
 *   grouping platform-subcomponent-ref-top {
 *     container subcomponents {
 *       list subcomponent {
 *         key name;
 *         leaf name {
 *           type leafref {
 *             path ../config/name;
 *           }
 *         }
 *         container config {
 *           uses platform-subcomponent-ref-config;
 *         }
 *         container state {
 *           config false;
 *           uses platform-subcomponent-ref-config;
 *           uses platform-subcomponent-ref-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping platform-component-config {
 *     leaf name {
 *       type string;
 *     }
 *   }
 *   grouping platform-component-state {
 *     leaf type {
 *       type union {
 *         type identityref {
 *           base OPENCONFIG_HARDWARE_COMPONENT;
 *         }
 *         type identityref {
 *           base OPENCONFIG_SOFTWARE_COMPONENT;
 *         }
 *       }
 *     }
 *     leaf id {
 *       type string;
 *     }
 *     leaf location {
 *       type string;
 *     }
 *     leaf description {
 *       type string;
 *     }
 *     leaf mfg-name {
 *       type string;
 *     }
 *     leaf mfg-date {
 *       type oc-yang:date;
 *     }
 *     leaf hardware-version {
 *       type string;
 *     }
 *     leaf firmware-version {
 *       type string;
 *     }
 *     leaf software-version {
 *       type string;
 *     }
 *     leaf serial-no {
 *       type string;
 *     }
 *     leaf part-no {
 *       type string;
 *     }
 *     leaf removable {
 *       type boolean;
 *     }
 *     leaf oper-status {
 *       type identityref {
 *         base COMPONENT_OPER_STATUS;
 *       }
 *     }
 *     leaf empty {
 *       type boolean;
 *       default false;
 *     }
 *     leaf parent {
 *       type leafref {
 *         path ../../../component/config/name;
 *       }
 *     }
 *   }
 *   grouping platform-component-temp-alarm-state {
 *     leaf alarm-status {
 *       type boolean;
 *     }
 *     leaf alarm-threshold {
 *       type uint32;
 *     }
 *     leaf alarm-severity {
 *       type identityref {
 *         base OPENCONFIG_ALARM_SEVERITY;
 *       }
 *     }
 *   }
 *   grouping platform-component-power-state {
 *     leaf allocated-power {
 *       type uint32;
 *       units watts;
 *     }
 *     leaf used-power {
 *       type uint32;
 *       units watts;
 *     }
 *   }
 *   grouping platform-component-temp-state {
 *     container temperature {
 *       uses oc-platform-types:avg-min-max-instant-stats-precision1-celsius;
 *       uses platform-component-temp-alarm-state;
 *     }
 *   }
 *   grouping platform-component-memory-state {
 *     container memory {
 *       leaf available {
 *         type uint64;
 *         units bytes;
 *       }
 *       leaf utilized {
 *         type uint64;
 *         units bytes;
 *       }
 *     }
 *   }
 *   grouping platform-anchors-top {
 *     container chassis {
 *       container config {
 *       }
 *       container state {
 *         config false;
 *       }
 *     }
 *     container port {
 *       container config {
 *       }
 *       container state {
 *         config false;
 *       }
 *     }
 *     container power-supply {
 *       container config {
 *       }
 *       container state {
 *         config false;
 *       }
 *     }
 *     container fan {
 *       container config {
 *       }
 *       container state {
 *         config false;
 *       }
 *     }
 *     container fabric {
 *       container config {
 *       }
 *       container state {
 *         config false;
 *       }
 *     }
 *     container storage {
 *       container config {
 *       }
 *       container state {
 *         config false;
 *       }
 *     }
 *     container cpu {
 *       container config {
 *       }
 *       container state {
 *         config false;
 *       }
 *     }
 *     container integrated-circuit {
 *       container config {
 *       }
 *       container state {
 *         config false;
 *       }
 *     }
 *     container backplane {
 *       container config {
 *       }
 *       container state {
 *         config false;
 *       }
 *     }
 *     container software-module {
 *       container config {
 *       }
 *       container state {
 *         config false;
 *       }
 *     }
 *   }
 *   grouping platform-component-top {
 *     container components {
 *       list component {
 *         key name;
 *         leaf name {
 *           type leafref {
 *             path ../config/name;
 *           }
 *         }
 *         container config {
 *           uses platform-component-config;
 *         }
 *         container state {
 *           config false;
 *           uses platform-component-config;
 *           uses platform-component-state;
 *           uses platform-component-temp-state;
 *           uses platform-component-memory-state;
 *           uses platform-component-power-state;
 *         }
 *         uses platform-component-properties-top;
 *         uses platform-subcomponent-ref-top;
 *         uses platform-anchors-top;
 *       }
 *     }
 *   }
 *   uses platform-component-top;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigPlatformData
    extends
    DataRoot,
    PlatformComponentTop
{





}

