package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.top.Openflow;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link System1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     System1 createSystem1(int fooXyzzy, int barBaz) {
 *         return new System1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of System1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see System1
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class System1Builder implements Builder<System1> {

    private Openflow _openflow;



    public System1Builder() {
    }
    
    
    public System1Builder(OpenflowTop arg) {
        this._openflow = arg.getOpenflow();
    }

    public System1Builder(System1 base) {
        this._openflow = base.getOpenflow();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>OpenflowTop</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenflowTop) {
            this._openflow = ((OpenflowTop)arg).getOpenflow();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[OpenflowTop]");
    }

    public Openflow getOpenflow() {
        return _openflow;
    }

    
    public System1Builder setOpenflow(final Openflow value) {
        this._openflow = value;
        return this;
    }
    

    @Override
    public System1 build() {
        return new System1Impl(this);
    }

    private static final class System1Impl
        implements System1 {
    
        private final Openflow _openflow;
    
        System1Impl(System1Builder base) {
            this._openflow = base.getOpenflow();
        }
    
        @Override
        public Openflow getOpenflow() {
            return _openflow;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = System1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return System1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return System1.bindingToString(this);
        }
    }
}
