package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Openflow controller config
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-openflow</b>
 * <pre>
 * grouping openflow-controller-config {
 *   leaf name {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-openflowopenflow-controller-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenflowControllerConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("openflow-controller-config");

    @Override
    Class<? extends OpenflowControllerConfig> implementedInterface();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Name of this Openflow controller. All connections for the same controller need
     *         to have the same name.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Name of this Openflow controller. All connections for the same controller need
     *         to have the same name.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }

}

