package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link Message} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Message createMessage(int fooXyzzy, int barBaz) {
 *         return new MessageBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Message, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Message
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class MessageBuilder implements Builder<Message> {

    private String _appName;
    private String _msg;
    private String _msgid;
    private Uint8 _priority;
    private String _procid;


    Map<Class<? extends Augmentation<Message>>, Augmentation<Message>> augmentation = Collections.emptyMap();

    public MessageBuilder() {
    }
    
    

    public MessageBuilder(Message base) {
        Map<Class<? extends Augmentation<Message>>, Augmentation<Message>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._appName = base.getAppName();
        this._msg = base.getMsg();
        this._msgid = base.getMsgid();
        this._priority = base.getPriority();
        this._procid = base.getProcid();
    }


    public String getAppName() {
        return _appName;
    }
    
    public String getMsg() {
        return _msg;
    }
    
    public String getMsgid() {
        return _msgid;
    }
    
    public Uint8 getPriority() {
        return _priority;
    }
    
    public String getProcid() {
        return _procid;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Message>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public MessageBuilder setAppName(final String value) {
        this._appName = value;
        return this;
    }
    
    public MessageBuilder setMsg(final String value) {
        this._msg = value;
        return this;
    }
    
    public MessageBuilder setMsgid(final String value) {
        this._msgid = value;
        return this;
    }
    
    public MessageBuilder setPriority(final Uint8 value) {
        this._priority = value;
        return this;
    }
    
    public MessageBuilder setProcid(final String value) {
        this._procid = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MessageBuilder addAugmentation(Augmentation<Message> augmentation) {
        Class<? extends Augmentation<Message>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MessageBuilder removeAugmentation(Class<? extends Augmentation<Message>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Message build() {
        return new MessageImpl(this);
    }

    private static final class MessageImpl
        extends AbstractAugmentable<Message>
        implements Message {
    
        private final String _appName;
        private final String _msg;
        private final String _msgid;
        private final Uint8 _priority;
        private final String _procid;
    
        MessageImpl(MessageBuilder base) {
            super(base.augmentation);
            this._appName = base.getAppName();
            this._msg = base.getMsg();
            this._msgid = base.getMsgid();
            this._priority = base.getPriority();
            this._procid = base.getProcid();
        }
    
        @Override
        public String getAppName() {
            return _appName;
        }
        
        @Override
        public String getMsg() {
            return _msg;
        }
        
        @Override
        public String getMsgid() {
            return _msgid;
        }
        
        @Override
        public Uint8 getPriority() {
            return _priority;
        }
        
        @Override
        public String getProcid() {
            return _procid;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Message.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Message.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Message.bindingToString(this);
        }
    }
}
