package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for enabling debug messages.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-messages</b>
 * <pre>
 * grouping debug-messages-config {
 *   leaf service {
 *     type identityref {
 *       base DEBUG_SERVICE;
 *     }
 *   }
 *   leaf enabled {
 *     type boolean;
 *     default false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-messagesdebug-messages-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface DebugMessagesConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("debug-messages-config");

    @Override
    Class<? extends DebugMessagesConfig> implementedInterface();
    
    /**
     * Return service, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enumeration of all services which can have debugging enabled. Vendors are to
     *         augment this base identity with their platform or OS specific debug options.
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends DEBUGSERVICE>} service, or {@code null} if it is not present.
     *
     */
    Class<? extends DEBUGSERVICE> getService();
    
    /**
     * Return service, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enumeration of all services which can have debugging enabled. Vendors are to
     *         augment this base identity with their platform or OS specific debug options.
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends DEBUGSERVICE>} service, guaranteed to be non-null.
     * @throws NoSuchElementException if service is not present
     *
     */
    default @NonNull Class<? extends DEBUGSERVICE> requireService() {
        return CodeHelpers.require(getService(), "service");
    }
    
    /**
     * Return enabled, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enable and disable debugging.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enabled, or {@code null} if it is not present.
     *
     */
    Boolean getEnabled();
    
    /**
     * Return enabled, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enable and disable debugging.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enabled, guaranteed to be non-null.
     * @throws NoSuchElementException if enabled is not present
     *
     */
    default @NonNull Boolean requireEnabled() {
        return CodeHelpers.require(getEnabled(), "enabled");
    }

}

