package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;

/**
 * Class that builds {@link State1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State1 createState1(int fooXyzzy, int barBaz) {
 *         return new State1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State1
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class State1Builder implements Builder<State1> {

    private Boolean _equipmentFailure;
    private Boolean _equipmentMismatch;



    public State1Builder() {
    }
    

    public State1Builder(State1 base) {
        this._equipmentFailure = base.getEquipmentFailure();
        this._equipmentMismatch = base.getEquipmentMismatch();
    }


    public Boolean getEquipmentFailure() {
        return _equipmentFailure;
    }
    
    public Boolean getEquipmentMismatch() {
        return _equipmentMismatch;
    }

    
    public State1Builder setEquipmentFailure(final Boolean value) {
        this._equipmentFailure = value;
        return this;
    }
    
    public State1Builder setEquipmentMismatch(final Boolean value) {
        this._equipmentMismatch = value;
        return this;
    }
    

    @Override
    public State1 build() {
        return new State1Impl(this);
    }

    private static final class State1Impl
        implements State1 {
    
        private final Boolean _equipmentFailure;
        private final Boolean _equipmentMismatch;
    
        State1Impl(State1Builder base) {
            this._equipmentFailure = base.getEquipmentFailure();
            this._equipmentMismatch = base.getEquipmentMismatch();
        }
    
        @Override
        public Boolean getEquipmentFailure() {
            return _equipmentFailure;
        }
        
        @Override
        public Boolean getEquipmentMismatch() {
            return _equipmentMismatch;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State1.bindingToString(this);
        }
    }
}
