package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.types.rev181121.OPENCONFIGALARMSEVERITY;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.types.rev181121.OPENCONFIGALARMTYPEID;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for device alarms
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-alarms</b>
 * <pre>
 * grouping alarm-state {
 *   leaf id {
 *     type string;
 *   }
 *   leaf resource {
 *     type string;
 *   }
 *   leaf text {
 *     type string;
 *   }
 *   leaf time-created {
 *     type oc-types:timeticks64;
 *   }
 *   leaf severity {
 *     type identityref {
 *       base OPENCONFIG_ALARM_SEVERITY;
 *     }
 *   }
 *   leaf type-id {
 *     type union {
 *       type string;
 *       type identityref {
 *         base OPENCONFIG_ALARM_TYPE_ID;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-alarmsalarm-state</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface AlarmState
    extends
    DataObject
{

    public static final class TypeId
     implements TypeObject, Serializable {
        private static final long serialVersionUID = 4533442976053019522L;
        private final String _string;
        private final Class<? extends OPENCONFIGALARMTYPEID> _identityref;
    
    
        public TypeId(String _string) {
            super();
            this._string = _string;
            this._identityref = null;
        }
        
        public TypeId(Class<? extends OPENCONFIGALARMTYPEID> _identityref) {
            super();
            this._identityref = _identityref;
            this._string = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public TypeId(TypeId source) {
            this._string = source._string;
            this._identityref = source._identityref;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_string != null) {
                return _string;
            }
            if (_identityref != null) {
                return _identityref.toString();
            }
        
            throw new IllegalStateException("No value assinged");
        }
    
    
        public String getString() {
            return _string;
        }
        
        public Class<? extends OPENCONFIGALARMTYPEID> getIdentityref() {
            return _identityref;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_string);
            result = prime * result + Objects.hashCode(_identityref);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypeId)) {
                return false;
            }
            final TypeId other = (TypeId) obj;
            if (!Objects.equals(_string, other._string)) {
                return false;
            }
            if (!Objects.equals(_identityref, other._identityref)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(TypeId.class);
            CodeHelpers.appendValue(helper, "_string", _string);
            CodeHelpers.appendValue(helper, "_identityref", _identityref);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("alarm-state");

    @Override
    Class<? extends AlarmState> implementedInterface();
    
    /**
     * Return id, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Unique ID for the alarm -- this will not be a configurable parameter on many
     *         implementations
     *     </code>
     * </pre>
     *
     * @return {@code String} id, or {@code null} if it is not present.
     *
     */
    String getId();
    
    /**
     * Return id, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Unique ID for the alarm -- this will not be a configurable parameter on many
     *         implementations
     *     </code>
     * </pre>
     *
     * @return {@code String} id, guaranteed to be non-null.
     * @throws NoSuchElementException if id is not present
     *
     */
    default @NonNull String requireId() {
        return CodeHelpers.require(getId(), "id");
    }
    
    /**
     * Return resource, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The item that is under alarm within the device. The resource may be a reference
     *         to an item which is defined elsewhere in the model. For example, it may be a
     *         platform/component, interfaces/interface,
     *         terminal-device/logical-channels/channel, etc. In this case the system should
     *         match the name of the referenced item exactly. The referenced item could
     *         alternatively be the path of the item within the model.
     *     </code>
     * </pre>
     *
     * @return {@code String} resource, or {@code null} if it is not present.
     *
     */
    String getResource();
    
    /**
     * Return resource, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The item that is under alarm within the device. The resource may be a reference
     *         to an item which is defined elsewhere in the model. For example, it may be a
     *         platform/component, interfaces/interface,
     *         terminal-device/logical-channels/channel, etc. In this case the system should
     *         match the name of the referenced item exactly. The referenced item could
     *         alternatively be the path of the item within the model.
     *     </code>
     * </pre>
     *
     * @return {@code String} resource, guaranteed to be non-null.
     * @throws NoSuchElementException if resource is not present
     *
     */
    default @NonNull String requireResource() {
        return CodeHelpers.require(getResource(), "resource");
    }
    
    /**
     * Return text, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The string used to inform operators about the alarm. This MUST contain enough
     *         information for an operator to be able to understand the problem. If this string
     *         contains structure, this format should be clearly documented for programs to be
     *         able to parse that information
     *     </code>
     * </pre>
     *
     * @return {@code String} text, or {@code null} if it is not present.
     *
     */
    String getText();
    
    /**
     * Return text, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The string used to inform operators about the alarm. This MUST contain enough
     *         information for an operator to be able to understand the problem. If this string
     *         contains structure, this format should be clearly documented for programs to be
     *         able to parse that information
     *     </code>
     * </pre>
     *
     * @return {@code String} text, guaranteed to be non-null.
     * @throws NoSuchElementException if text is not present
     *
     */
    default @NonNull String requireText() {
        return CodeHelpers.require(getText(), "text");
    }
    
    /**
     * Return timeCreated, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The time at which the alarm was raised by the system. This value is expressed
     *         relative to the Unix Epoch.
     *     </code>
     * </pre>
     *
     * @return {@code Timeticks64} timeCreated, or {@code null} if it is not present.
     *
     */
    Timeticks64 getTimeCreated();
    
    /**
     * Return timeCreated, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The time at which the alarm was raised by the system. This value is expressed
     *         relative to the Unix Epoch.
     *     </code>
     * </pre>
     *
     * @return {@code Timeticks64} timeCreated, guaranteed to be non-null.
     * @throws NoSuchElementException if timeCreated is not present
     *
     */
    default @NonNull Timeticks64 requireTimeCreated() {
        return CodeHelpers.require(getTimeCreated(), "timecreated");
    }
    
    /**
     * Return severity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The severity level indicating the criticality and impact of the alarm
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends OPENCONFIGALARMSEVERITY>} severity, or {@code null} if it is not present.
     *
     */
    Class<? extends OPENCONFIGALARMSEVERITY> getSeverity();
    
    /**
     * Return severity, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The severity level indicating the criticality and impact of the alarm
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends OPENCONFIGALARMSEVERITY>} severity, guaranteed to be non-null.
     * @throws NoSuchElementException if severity is not present
     *
     */
    default @NonNull Class<? extends OPENCONFIGALARMSEVERITY> requireSeverity() {
        return CodeHelpers.require(getSeverity(), "severity");
    }
    
    /**
     * Return typeId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The abbreviated name of the alarm, for example LOS, EQPT, or OTS. Also referred
     *         to in different systems as condition type, alarm identifier, or alarm mnemonic.
     *         It is recommended to use the OPENCONFIG_ALARM_TYPE_ID identities where possible
     *         and only use the string type when the desired identityref is not yet defined
     *     </code>
     * </pre>
     *
     * @return {@code TypeId} typeId, or {@code null} if it is not present.
     *
     */
    TypeId getTypeId();
    
    /**
     * Return typeId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The abbreviated name of the alarm, for example LOS, EQPT, or OTS. Also referred
     *         to in different systems as condition type, alarm identifier, or alarm mnemonic.
     *         It is recommended to use the OPENCONFIG_ALARM_TYPE_ID identities where possible
     *         and only use the string type when the desired identityref is not yet defined
     *     </code>
     * </pre>
     *
     * @return {@code TypeId} typeId, guaranteed to be non-null.
     * @throws NoSuchElementException if typeId is not present
     *
     */
    default @NonNull TypeId requireTypeId() {
        return CodeHelpers.require(getTypeId(), "typeid");
    }

}

