package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder implements Builder<State> {

    private IpAddress _address;
    private Counter64 _connectionAborts;
    private Counter64 _connectionCloses;
    private Counter64 _connectionFailures;
    private Counter64 _connectionOpens;
    private Counter64 _connectionTimeouts;
    private Counter64 _errorsReceived;
    private Counter64 _messagesReceived;
    private Counter64 _messagesSent;
    private String _name;
    private Uint16 _timeout;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }
    
    
    
    public StateBuilder(AaaServerConfig arg) {
        this._name = arg.getName();
        this._address = arg.getAddress();
        this._timeout = arg.getTimeout();
    }
    
    public StateBuilder(AaaServerState arg) {
        this._connectionOpens = arg.getConnectionOpens();
        this._connectionCloses = arg.getConnectionCloses();
        this._connectionAborts = arg.getConnectionAborts();
        this._connectionFailures = arg.getConnectionFailures();
        this._connectionTimeouts = arg.getConnectionTimeouts();
        this._messagesSent = arg.getMessagesSent();
        this._messagesReceived = arg.getMessagesReceived();
        this._errorsReceived = arg.getErrorsReceived();
    }

    public StateBuilder(State base) {
        Map<Class<? extends Augmentation<State>>, Augmentation<State>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._address = base.getAddress();
        this._connectionAborts = base.getConnectionAborts();
        this._connectionCloses = base.getConnectionCloses();
        this._connectionFailures = base.getConnectionFailures();
        this._connectionOpens = base.getConnectionOpens();
        this._connectionTimeouts = base.getConnectionTimeouts();
        this._errorsReceived = base.getErrorsReceived();
        this._messagesReceived = base.getMessagesReceived();
        this._messagesSent = base.getMessagesSent();
        this._name = base.getName();
        this._timeout = base.getTimeout();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>AaaServerState</li>
     * <li>AaaServerConfig</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaServerState) {
            this._connectionOpens = ((AaaServerState)arg).getConnectionOpens();
            this._connectionCloses = ((AaaServerState)arg).getConnectionCloses();
            this._connectionAborts = ((AaaServerState)arg).getConnectionAborts();
            this._connectionFailures = ((AaaServerState)arg).getConnectionFailures();
            this._connectionTimeouts = ((AaaServerState)arg).getConnectionTimeouts();
            this._messagesSent = ((AaaServerState)arg).getMessagesSent();
            this._messagesReceived = ((AaaServerState)arg).getMessagesReceived();
            this._errorsReceived = ((AaaServerState)arg).getErrorsReceived();
            isValidArg = true;
        }
        if (arg instanceof AaaServerConfig) {
            this._name = ((AaaServerConfig)arg).getName();
            this._address = ((AaaServerConfig)arg).getAddress();
            this._timeout = ((AaaServerConfig)arg).getTimeout();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AaaServerState, AaaServerConfig]");
    }

    public IpAddress getAddress() {
        return _address;
    }
    
    public Counter64 getConnectionAborts() {
        return _connectionAborts;
    }
    
    public Counter64 getConnectionCloses() {
        return _connectionCloses;
    }
    
    public Counter64 getConnectionFailures() {
        return _connectionFailures;
    }
    
    public Counter64 getConnectionOpens() {
        return _connectionOpens;
    }
    
    public Counter64 getConnectionTimeouts() {
        return _connectionTimeouts;
    }
    
    public Counter64 getErrorsReceived() {
        return _errorsReceived;
    }
    
    public Counter64 getMessagesReceived() {
        return _messagesReceived;
    }
    
    public Counter64 getMessagesSent() {
        return _messagesSent;
    }
    
    public String getName() {
        return _name;
    }
    
    public Uint16 getTimeout() {
        return _timeout;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public StateBuilder setAddress(final IpAddress value) {
        this._address = value;
        return this;
    }
    
    public StateBuilder setConnectionAborts(final Counter64 value) {
        this._connectionAborts = value;
        return this;
    }
    
    public StateBuilder setConnectionCloses(final Counter64 value) {
        this._connectionCloses = value;
        return this;
    }
    
    public StateBuilder setConnectionFailures(final Counter64 value) {
        this._connectionFailures = value;
        return this;
    }
    
    public StateBuilder setConnectionOpens(final Counter64 value) {
        this._connectionOpens = value;
        return this;
    }
    
    public StateBuilder setConnectionTimeouts(final Counter64 value) {
        this._connectionTimeouts = value;
        return this;
    }
    
    public StateBuilder setErrorsReceived(final Counter64 value) {
        this._errorsReceived = value;
        return this;
    }
    
    public StateBuilder setMessagesReceived(final Counter64 value) {
        this._messagesReceived = value;
        return this;
    }
    
    public StateBuilder setMessagesSent(final Counter64 value) {
        this._messagesSent = value;
        return this;
    }
    
    public StateBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    public StateBuilder setTimeout(final Uint16 value) {
        this._timeout = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class<? extends Augmentation<State>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final IpAddress _address;
        private final Counter64 _connectionAborts;
        private final Counter64 _connectionCloses;
        private final Counter64 _connectionFailures;
        private final Counter64 _connectionOpens;
        private final Counter64 _connectionTimeouts;
        private final Counter64 _errorsReceived;
        private final Counter64 _messagesReceived;
        private final Counter64 _messagesSent;
        private final String _name;
        private final Uint16 _timeout;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._connectionAborts = base.getConnectionAborts();
            this._connectionCloses = base.getConnectionCloses();
            this._connectionFailures = base.getConnectionFailures();
            this._connectionOpens = base.getConnectionOpens();
            this._connectionTimeouts = base.getConnectionTimeouts();
            this._errorsReceived = base.getErrorsReceived();
            this._messagesReceived = base.getMessagesReceived();
            this._messagesSent = base.getMessagesSent();
            this._name = base.getName();
            this._timeout = base.getTimeout();
        }
    
        @Override
        public IpAddress getAddress() {
            return _address;
        }
        
        @Override
        public Counter64 getConnectionAborts() {
            return _connectionAborts;
        }
        
        @Override
        public Counter64 getConnectionCloses() {
            return _connectionCloses;
        }
        
        @Override
        public Counter64 getConnectionFailures() {
            return _connectionFailures;
        }
        
        @Override
        public Counter64 getConnectionOpens() {
            return _connectionOpens;
        }
        
        @Override
        public Counter64 getConnectionTimeouts() {
            return _connectionTimeouts;
        }
        
        @Override
        public Counter64 getErrorsReceived() {
            return _errorsReceived;
        }
        
        @Override
        public Counter64 getMessagesReceived() {
            return _messagesReceived;
        }
        
        @Override
        public Counter64 getMessagesSent() {
            return _messagesSent;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public Uint16 getTimeout() {
            return _timeout;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
