package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaRadiusServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaTacacsServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.top.Radius;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.tacacs.server.top.Tacacs;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Server} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Server createServer(int fooXyzzy, int barBaz) {
 *         return new ServerBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Server, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Server
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ServerBuilder implements Builder<Server> {

    private IpAddress _address;
    private Config _config;
    private Radius _radius;
    private State _state;
    private Tacacs _tacacs;
    private ServerKey key;


    Map<Class<? extends Augmentation<Server>>, Augmentation<Server>> augmentation = Collections.emptyMap();

    public ServerBuilder() {
    }
    
    
    
    public ServerBuilder(AaaTacacsServerTop arg) {
        this._tacacs = arg.getTacacs();
    }
    
    public ServerBuilder(AaaRadiusServerTop arg) {
        this._radius = arg.getRadius();
    }
    

    public ServerBuilder(Server base) {
        Map<Class<? extends Augmentation<Server>>, Augmentation<Server>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._address = base.getAddress();
        this._config = base.getConfig();
        this._radius = base.getRadius();
        this._state = base.getState();
        this._tacacs = base.getTacacs();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>AaaRadiusServerTop</li>
     * <li>AaaTacacsServerTop</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaRadiusServerTop) {
            this._radius = ((AaaRadiusServerTop)arg).getRadius();
            isValidArg = true;
        }
        if (arg instanceof AaaTacacsServerTop) {
            this._tacacs = ((AaaTacacsServerTop)arg).getTacacs();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AaaRadiusServerTop, AaaTacacsServerTop]");
    }

    public ServerKey key() {
        return key;
    }
    
    public IpAddress getAddress() {
        return _address;
    }
    
    public Config getConfig() {
        return _config;
    }
    
    public Radius getRadius() {
        return _radius;
    }
    
    public State getState() {
        return _state;
    }
    
    public Tacacs getTacacs() {
        return _tacacs;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Server>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ServerBuilder withKey(final ServerKey key) {
        this.key = key;
        return this;
    }
    
    public ServerBuilder setAddress(final IpAddress value) {
        this._address = value;
        return this;
    }
    
    public ServerBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    public ServerBuilder setRadius(final Radius value) {
        this._radius = value;
        return this;
    }
    
    public ServerBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    public ServerBuilder setTacacs(final Tacacs value) {
        this._tacacs = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ServerBuilder addAugmentation(Augmentation<Server> augmentation) {
        Class<? extends Augmentation<Server>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ServerBuilder removeAugmentation(Class<? extends Augmentation<Server>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Server build() {
        return new ServerImpl(this);
    }

    private static final class ServerImpl
        extends AbstractAugmentable<Server>
        implements Server {
    
        private final IpAddress _address;
        private final Config _config;
        private final Radius _radius;
        private final State _state;
        private final Tacacs _tacacs;
        private final ServerKey key;
    
        ServerImpl(ServerBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new ServerKey(base.getAddress());
            }
            this._address = key.getAddress();
            this._config = base.getConfig();
            this._radius = base.getRadius();
            this._state = base.getState();
            this._tacacs = base.getTacacs();
        }
    
        @Override
        public ServerKey key() {
            return key;
        }
        
        @Override
        public IpAddress getAddress() {
            return _address;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public Radius getRadius() {
            return _radius;
        }
        
        @Override
        public State getState() {
            return _state;
        }
        
        @Override
        public Tacacs getTacacs() {
            return _tacacs;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Server.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Server.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Server.bindingToString(this);
        }
    }
}
