package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthenticationUserTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.users.User;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.users.UserKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container list of local users
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * container users {
 *   list user {
 *     key username;
 *     leaf username {
 *       type leafref {
 *         path ../config/username;
 *       }
 *     }
 *     container config {
 *       uses aaa-authentication-user-config;
 *     }
 *     container state {
 *       config false;
 *       uses aaa-authentication-user-config;
 *       uses aaa-authentication-user-state;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-aaaaaa-authentication-user-topusers</i>
 *
 * <p>To create instances of this class use {@link UsersBuilder}.
 * @see UsersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Users
    extends
    ChildOf<AaaAuthenticationUserTop>,
    Augmentable<Users>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("users");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.Users> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.Users.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.@NonNull Users obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getUser());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.@NonNull Users thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.Users other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.Users.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getUser(), other.getUser())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.@NonNull Users obj) {
        final var helper = MoreObjects.toStringHelper("Users");
        CodeHelpers.appendValue(helper, "user", obj.getUser());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return user, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of local users on the system
     *     </code>
     * </pre>
     *
     * @return {@code Map<UserKey, User>} user, or {@code null} if it is not present.
     *
     */
    @Nullable Map<UserKey, User> getUser();
    
    /**
     * Return user, or an empty list if it is not present.
     *
     * @return {@code Map<UserKey, User>} user, or an empty list if it is not present.
     *
     */
    default @NonNull Map<UserKey, User> nonnullUser() {
        return CodeHelpers.nonnull(getUser());
    }

}

