package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.top.Authorization;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for AAA authorization
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-authorization-top {
 *   container authorization {
 *     container config {
 *       uses aaa-authorization-config;
 *     }
 *     container state {
 *       config false;
 *       uses aaa-authorization-config;
 *       uses aaa-authorization-state;
 *     }
 *     uses aaa-authorization-events-top;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-aaaaaa-authorization-top</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAuthorizationTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-authorization-top");

    @Override
    Class<? extends AaaAuthorizationTop> implementedInterface();
    
    /**
     * Return authorization, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for AAA authorization configuration and operational state
     *         data
     *     </code>
     * </pre>
     *
     * @return {@code Authorization} authorization, or {@code null} if it is not present.
     *
     */
    Authorization getAuthorization();

}

