package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.SYSTEMDEFINEDROLES;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for local users
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-authentication-user-config {
 *   leaf username {
 *     type string;
 *   }
 *   leaf password {
 *     type string;
 *     oc-ext:openconfig-hashed-value;
 *   }
 *   leaf password-hashed {
 *     type oc-aaa-types:crypt-password-type;
 *   }
 *   leaf ssh-key {
 *     type string;
 *   }
 *   leaf role {
 *     type union {
 *       type string;
 *       type identityref {
 *         base SYSTEM_DEFINED_ROLES;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-aaaaaa-authentication-user-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAuthenticationUserConfig
    extends
    DataObject
{

    public static final class Role
     implements TypeObject, Serializable {
        private static final long serialVersionUID = -6280634862704069872L;
        private final String _string;
        private final Class<? extends SYSTEMDEFINEDROLES> _identityref;
    
    
        public Role(String _string) {
            super();
            this._string = _string;
            this._identityref = null;
        }
        
        public Role(Class<? extends SYSTEMDEFINEDROLES> _identityref) {
            super();
            this._identityref = _identityref;
            this._string = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Role(Role source) {
            this._string = source._string;
            this._identityref = source._identityref;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_string != null) {
                return _string;
            }
            if (_identityref != null) {
                return _identityref.toString();
            }
        
            throw new IllegalStateException("No value assinged");
        }
    
    
        public String getString() {
            return _string;
        }
        
        public Class<? extends SYSTEMDEFINEDROLES> getIdentityref() {
            return _identityref;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_string);
            result = prime * result + Objects.hashCode(_identityref);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Role)) {
                return false;
            }
            final Role other = (Role) obj;
            if (!Objects.equals(_string, other._string)) {
                return false;
            }
            if (!Objects.equals(_identityref, other._identityref)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(Role.class);
            CodeHelpers.appendValue(helper, "_string", _string);
            CodeHelpers.appendValue(helper, "_identityref", _identityref);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-authentication-user-config");

    @Override
    Class<? extends AaaAuthenticationUserConfig> implementedInterface();
    
    /**
     * Return username, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Assigned username for this user
     *     </code>
     * </pre>
     *
     * @return {@code String} username, or {@code null} if it is not present.
     *
     */
    String getUsername();
    
    /**
     * Return username, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Assigned username for this user
     *     </code>
     * </pre>
     *
     * @return {@code String} username, guaranteed to be non-null.
     * @throws NoSuchElementException if username is not present
     *
     */
    default @NonNull String requireUsername() {
        return CodeHelpers.require(getUsername(), "username");
    }
    
    /**
     * Return password, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The user password, supplied as cleartext. The system must hash the value and
     *         only store the hashed value.
     *     </code>
     * </pre>
     *
     * @return {@code String} password, or {@code null} if it is not present.
     *
     */
    String getPassword();
    
    /**
     * Return password, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The user password, supplied as cleartext. The system must hash the value and
     *         only store the hashed value.
     *     </code>
     * </pre>
     *
     * @return {@code String} password, guaranteed to be non-null.
     * @throws NoSuchElementException if password is not present
     *
     */
    default @NonNull String requirePassword() {
        return CodeHelpers.require(getPassword(), "password");
    }
    
    /**
     * Return passwordHashed, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The user password, supplied as a hashed value using the notation described in
     *         the definition of the crypt-password-type.
     *     </code>
     * </pre>
     *
     * @return {@code CryptPasswordType} passwordHashed, or {@code null} if it is not present.
     *
     */
    CryptPasswordType getPasswordHashed();
    
    /**
     * Return passwordHashed, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The user password, supplied as a hashed value using the notation described in
     *         the definition of the crypt-password-type.
     *     </code>
     * </pre>
     *
     * @return {@code CryptPasswordType} passwordHashed, guaranteed to be non-null.
     * @throws NoSuchElementException if passwordHashed is not present
     *
     */
    default @NonNull CryptPasswordType requirePasswordHashed() {
        return CodeHelpers.require(getPasswordHashed(), "passwordhashed");
    }
    
    /**
     * Return sshKey, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         SSH public key for the user (RSA or DSA)
     *     </code>
     * </pre>
     *
     * @return {@code String} sshKey, or {@code null} if it is not present.
     *
     */
    String getSshKey();
    
    /**
     * Return sshKey, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         SSH public key for the user (RSA or DSA)
     *     </code>
     * </pre>
     *
     * @return {@code String} sshKey, guaranteed to be non-null.
     * @throws NoSuchElementException if sshKey is not present
     *
     */
    default @NonNull String requireSshKey() {
        return CodeHelpers.require(getSshKey(), "sshkey");
    }
    
    /**
     * Return role, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Role assigned to the user. The role may be supplied as a string or a role
     *         defined by the SYSTEM_DEFINED_ROLES identity.
     *     </code>
     * </pre>
     *
     * @return {@code Role} role, or {@code null} if it is not present.
     *
     */
    Role getRole();
    
    /**
     * Return role, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Role assigned to the user. The role may be supplied as a string or a role
     *         defined by the SYSTEM_DEFINED_ROLES identity.
     *     </code>
     * </pre>
     *
     * @return {@code Role} role, guaranteed to be non-null.
     * @throws NoSuchElementException if role is not present
     *
     */
    default @NonNull Role requireRole() {
        return CodeHelpers.require(getRole(), "role");
    }

}

