package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.AAAMETHODTYPE;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common definitions for accounting methods
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-accounting-methods-common {
 *   leaf-list accounting-method {
 *     type union {
 *       type identityref {
 *         base AAA_METHOD_TYPE;
 *       }
 *       type string;
 *     }
 *     ordered-by user;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-aaaaaa-accounting-methods-common</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAccountingMethodsCommon
    extends
    DataObject
{

    public static final class AccountingMethod
     implements TypeObject, Serializable {
        private static final long serialVersionUID = -5852145385958523278L;
        private final Class<? extends AAAMETHODTYPE> _identityref;
        private final String _string;
    
    
        public AccountingMethod(Class<? extends AAAMETHODTYPE> _identityref) {
            super();
            this._identityref = _identityref;
            this._string = null;
        }
        
        public AccountingMethod(String _string) {
            super();
            this._string = _string;
            this._identityref = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public AccountingMethod(AccountingMethod source) {
            this._identityref = source._identityref;
            this._string = source._string;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_identityref != null) {
                return _identityref.toString();
            }
            if (_string != null) {
                return _string;
            }
        
            throw new IllegalStateException("No value assinged");
        }
    
    
        public Class<? extends AAAMETHODTYPE> getIdentityref() {
            return _identityref;
        }
        
        public String getString() {
            return _string;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_identityref);
            result = prime * result + Objects.hashCode(_string);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AccountingMethod)) {
                return false;
            }
            final AccountingMethod other = (AccountingMethod) obj;
            if (!Objects.equals(_identityref, other._identityref)) {
                return false;
            }
            if (!Objects.equals(_string, other._string)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(AccountingMethod.class);
            CodeHelpers.appendValue(helper, "_identityref", _identityref);
            CodeHelpers.appendValue(helper, "_string", _string);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-accounting-methods-common");

    @Override
    Class<? extends AaaAccountingMethodsCommon> implementedInterface();
    
    /**
     * Return accountingMethod, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An ordered list of methods used for AAA accounting for this event type. The
     *         method is defined by the destination for accounting data, which may be specified
     *         as the group of all TACACS+/RADIUS servers, a defined server group, or the local
     *         system.
     *     </code>
     * </pre>
     *
     * @return {@code List<AccountingMethod>} accountingMethod, or {@code null} if it is not present.
     *
     */
    @Nullable List<AccountingMethod> getAccountingMethod();
    
    /**
     * Return accountingMethod, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         An ordered list of methods used for AAA accounting for this event type. The
     *         method is defined by the destination for accounting data, which may be specified
     *         as the group of all TACACS+/RADIUS servers, a defined server group, or the local
     *         system.
     *     </code>
     * </pre>
     *
     * @return {@code List<AccountingMethod>} accountingMethod, guaranteed to be non-null.
     * @throws NoSuchElementException if accountingMethod is not present
     *
     */
    default @NonNull List<AccountingMethod> requireAccountingMethod() {
        return CodeHelpers.require(getAccountingMethod(), "accountingmethod");
    }

}

