/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint16;

public class VlanId
implements ScalarTypeObject<Uint16>,
Serializable {
    private static final long serialVersionUID = -3708880084115267596L;
    private final Uint16 _value;

    private static void check_valueRange(int value) {
        if (value >= 1 && value <= 4094) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..4094]]", (int)value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public VlanId(Uint16 _value) {
        if (_value != null) {
            VlanId.check_valueRange(_value.intValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public VlanId(VlanId source) {
        this._value = source._value;
    }

    public static VlanId getDefaultInstance(String defaultValue) {
        return new VlanId(Uint16.valueOf((String)defaultValue));
    }

    public Uint16 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VlanId)) {
            return false;
        }
        VlanId other = (VlanId)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(VlanId.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

