/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.top;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanLogicalEgressMappingTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanLogicalIngressMappingTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanLogicalMatchTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.egress.mapping.top.EgressMapping;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.ingress.mapping.top.IngressMapping;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.Match;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.top.Vlan;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.top.vlan.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.top.vlan.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VlanBuilder
implements Builder<Vlan> {
    private Config _config;
    private EgressMapping _egressMapping;
    private IngressMapping _ingressMapping;
    private Match _match;
    private State _state;
    Map<Class<? extends Augmentation<Vlan>>, Augmentation<Vlan>> augmentation = Collections.emptyMap();

    public VlanBuilder() {
    }

    public VlanBuilder(VlanLogicalMatchTop arg) {
        this._match = arg.getMatch();
    }

    public VlanBuilder(VlanLogicalIngressMappingTop arg) {
        this._ingressMapping = arg.getIngressMapping();
    }

    public VlanBuilder(VlanLogicalEgressMappingTop arg) {
        this._egressMapping = arg.getEgressMapping();
    }

    public VlanBuilder(Vlan base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Vlan>>, Augmentation<Vlan>>(aug);
        }
        this._config = base.getConfig();
        this._egressMapping = base.getEgressMapping();
        this._ingressMapping = base.getIngressMapping();
        this._match = base.getMatch();
        this._state = base.getState();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanLogicalEgressMappingTop) {
            this._egressMapping = ((VlanLogicalEgressMappingTop)arg).getEgressMapping();
            isValidArg = true;
        }
        if (arg instanceof VlanLogicalMatchTop) {
            this._match = ((VlanLogicalMatchTop)arg).getMatch();
            isValidArg = true;
        }
        if (arg instanceof VlanLogicalIngressMappingTop) {
            this._ingressMapping = ((VlanLogicalIngressMappingTop)arg).getIngressMapping();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[VlanLogicalEgressMappingTop, VlanLogicalMatchTop, VlanLogicalIngressMappingTop]");
    }

    public Config getConfig() {
        return this._config;
    }

    public EgressMapping getEgressMapping() {
        return this._egressMapping;
    }

    public IngressMapping getIngressMapping() {
        return this._ingressMapping;
    }

    public Match getMatch() {
        return this._match;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Vlan>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public VlanBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public VlanBuilder setEgressMapping(EgressMapping value) {
        this._egressMapping = value;
        return this;
    }

    public VlanBuilder setIngressMapping(IngressMapping value) {
        this._ingressMapping = value;
        return this;
    }

    public VlanBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public VlanBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public VlanBuilder addAugmentation(Augmentation<Vlan> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Vlan>>, Augmentation<Vlan>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public VlanBuilder removeAugmentation(Class<? extends Augmentation<Vlan>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Vlan build() {
        return new VlanImpl(this);
    }

    private static final class VlanImpl
    extends AbstractAugmentable<Vlan>
    implements Vlan {
        private final Config _config;
        private final EgressMapping _egressMapping;
        private final IngressMapping _ingressMapping;
        private final Match _match;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        VlanImpl(VlanBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._egressMapping = base.getEgressMapping();
            this._ingressMapping = base.getIngressMapping();
            this._match = base.getMatch();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public EgressMapping getEgressMapping() {
            return this._egressMapping;
        }

        @Override
        public IngressMapping getIngressMapping() {
            return this._ingressMapping;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Vlan.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Vlan.bindingEquals(this, obj);
        }

        public String toString() {
            return Vlan.bindingToString(this);
        }
    }
}

