/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemGlobalConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.DomainName;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder
implements Builder<Config> {
    private DomainName _domainName;
    private DomainName _hostname;
    private String _loginBanner;
    private String _motdBanner;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(SystemGlobalConfig arg) {
        this._hostname = arg.getHostname();
        this._domainName = arg.getDomainName();
        this._loginBanner = arg.getLoginBanner();
        this._motdBanner = arg.getMotdBanner();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._domainName = base.getDomainName();
        this._hostname = base.getHostname();
        this._loginBanner = base.getLoginBanner();
        this._motdBanner = base.getMotdBanner();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemGlobalConfig) {
            this._hostname = ((SystemGlobalConfig)arg).getHostname();
            this._domainName = ((SystemGlobalConfig)arg).getDomainName();
            this._loginBanner = ((SystemGlobalConfig)arg).getLoginBanner();
            this._motdBanner = ((SystemGlobalConfig)arg).getMotdBanner();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemGlobalConfig]");
    }

    public DomainName getDomainName() {
        return this._domainName;
    }

    public DomainName getHostname() {
        return this._hostname;
    }

    public String getLoginBanner() {
        return this._loginBanner;
    }

    public String getMotdBanner() {
        return this._motdBanner;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setDomainName(DomainName value) {
        this._domainName = value;
        return this;
    }

    public ConfigBuilder setHostname(DomainName value) {
        this._hostname = value;
        return this;
    }

    public ConfigBuilder setLoginBanner(String value) {
        this._loginBanner = value;
        return this;
    }

    public ConfigBuilder setMotdBanner(String value) {
        this._motdBanner = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final DomainName _domainName;
        private final DomainName _hostname;
        private final String _loginBanner;
        private final String _motdBanner;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._domainName = base.getDomainName();
            this._hostname = base.getHostname();
            this._loginBanner = base.getLoginBanner();
            this._motdBanner = base.getMotdBanner();
        }

        @Override
        public DomainName getDomainName() {
            return this._domainName;
        }

        @Override
        public DomainName getHostname() {
            return this._hostname;
        }

        @Override
        public String getLoginBanner() {
            return this._loginBanner;
        }

        @Override
        public String getMotdBanner() {
            return this._motdBanner;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

