/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.top.dns;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.top.dns.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.DomainName;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder
implements Builder<Config> {
    private List<DomainName> _search;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(SystemDnsConfig arg) {
        this._search = arg.getSearch();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._search = base.getSearch();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemDnsConfig) {
            this._search = ((SystemDnsConfig)arg).getSearch();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemDnsConfig]");
    }

    public List<DomainName> getSearch() {
        return this._search;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setSearch(List<DomainName> values) {
        this._search = values;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final List<DomainName> _search;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._search = base.getSearch();
        }

        @Override
        public List<DomainName> getSearch() {
            return this._search;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

