/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.host.entry;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsStaticConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsStaticState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.host.entries.host.entry.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv4Address;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv6Address;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder
implements Builder<State> {
    private List<String> _alias;
    private String _hostname;
    private List<Ipv4Address> _ipv4Address;
    private List<Ipv6Address> _ipv6Address;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }

    public StateBuilder(SystemDnsStaticConfig arg) {
        this._hostname = arg.getHostname();
        this._alias = arg.getAlias();
        this._ipv4Address = arg.getIpv4Address();
        this._ipv6Address = arg.getIpv6Address();
    }

    public StateBuilder(SystemDnsStaticState arg) {
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._alias = base.getAlias();
        this._hostname = base.getHostname();
        this._ipv4Address = base.getIpv4Address();
        this._ipv6Address = base.getIpv6Address();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemDnsStaticState) {
            isValidArg = true;
        }
        if (arg instanceof SystemDnsStaticConfig) {
            this._hostname = ((SystemDnsStaticConfig)arg).getHostname();
            this._alias = ((SystemDnsStaticConfig)arg).getAlias();
            this._ipv4Address = ((SystemDnsStaticConfig)arg).getIpv4Address();
            this._ipv6Address = ((SystemDnsStaticConfig)arg).getIpv6Address();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemDnsStaticState, SystemDnsStaticConfig]");
    }

    public List<String> getAlias() {
        return this._alias;
    }

    public String getHostname() {
        return this._hostname;
    }

    public List<Ipv4Address> getIpv4Address() {
        return this._ipv4Address;
    }

    public List<Ipv6Address> getIpv6Address() {
        return this._ipv6Address;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setAlias(List<String> values) {
        this._alias = values;
        return this;
    }

    public StateBuilder setHostname(String value) {
        this._hostname = value;
        return this;
    }

    public StateBuilder setIpv4Address(List<Ipv4Address> values) {
        this._ipv4Address = values;
        return this;
    }

    public StateBuilder setIpv6Address(List<Ipv6Address> values) {
        this._ipv6Address = values;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final List<String> _alias;
        private final String _hostname;
        private final List<Ipv4Address> _ipv4Address;
        private final List<Ipv6Address> _ipv6Address;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._alias = base.getAlias();
            this._hostname = base.getHostname();
            this._ipv4Address = base.getIpv4Address();
            this._ipv6Address = base.getIpv6Address();
        }

        @Override
        public List<String> getAlias() {
            return this._alias;
        }

        @Override
        public String getHostname() {
            return this._hostname;
        }

        @Override
        public List<Ipv4Address> getIpv4Address() {
            return this._ipv4Address;
        }

        @Override
        public List<Ipv6Address> getIpv6Address() {
            return this._ipv6Address;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

