/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.remote.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingRemoteConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.remote.server.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder
implements Builder<Config> {
    private Host _host;
    private PortNumber _remotePort;
    private IpAddress _sourceAddress;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(LoggingRemoteConfig arg) {
        this._host = arg.getHost();
        this._sourceAddress = arg.getSourceAddress();
        this._remotePort = arg.getRemotePort();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._host = base.getHost();
        this._remotePort = base.getRemotePort();
        this._sourceAddress = base.getSourceAddress();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LoggingRemoteConfig) {
            this._host = ((LoggingRemoteConfig)arg).getHost();
            this._sourceAddress = ((LoggingRemoteConfig)arg).getSourceAddress();
            this._remotePort = ((LoggingRemoteConfig)arg).getRemotePort();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[LoggingRemoteConfig]");
    }

    public Host getHost() {
        return this._host;
    }

    public PortNumber getRemotePort() {
        return this._remotePort;
    }

    public IpAddress getSourceAddress() {
        return this._sourceAddress;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setHost(Host value) {
        this._host = value;
        return this;
    }

    public ConfigBuilder setRemotePort(PortNumber value) {
        this._remotePort = value;
        return this;
    }

    public ConfigBuilder setSourceAddress(IpAddress value) {
        this._sourceAddress = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final Host _host;
        private final PortNumber _remotePort;
        private final IpAddress _sourceAddress;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._host = base.getHost();
            this._remotePort = base.getRemotePort();
            this._sourceAddress = base.getSourceAddress();
        }

        @Override
        public Host getHost() {
            return this._host;
        }

        @Override
        public PortNumber getRemotePort() {
            return this._remotePort;
        }

        @Override
        public IpAddress getSourceAddress() {
            return this._sourceAddress;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

