/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.console.top;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingSelectorsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.console.top.Console;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.console.top.console.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.console.top.console.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.Selectors;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConsoleBuilder
implements Builder<Console> {
    private Config _config;
    private Selectors _selectors;
    private State _state;
    Map<Class<? extends Augmentation<Console>>, Augmentation<Console>> augmentation = Collections.emptyMap();

    public ConsoleBuilder() {
    }

    public ConsoleBuilder(LoggingSelectorsTop arg) {
        this._selectors = arg.getSelectors();
    }

    public ConsoleBuilder(Console base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Console>>, Augmentation<Console>>(aug);
        }
        this._config = base.getConfig();
        this._selectors = base.getSelectors();
        this._state = base.getState();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LoggingSelectorsTop) {
            this._selectors = ((LoggingSelectorsTop)arg).getSelectors();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[LoggingSelectorsTop]");
    }

    public Config getConfig() {
        return this._config;
    }

    public Selectors getSelectors() {
        return this._selectors;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Console>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConsoleBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public ConsoleBuilder setSelectors(Selectors value) {
        this._selectors = value;
        return this;
    }

    public ConsoleBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public ConsoleBuilder addAugmentation(Augmentation<Console> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Console>>, Augmentation<Console>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConsoleBuilder removeAugmentation(Class<? extends Augmentation<Console>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Console build() {
        return new ConsoleImpl(this);
    }

    private static final class ConsoleImpl
    extends AbstractAugmentable<Console>
    implements Console {
        private final Config _config;
        private final Selectors _selectors;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConsoleImpl(ConsoleBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._selectors = base.getSelectors();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public Selectors getSelectors() {
            return this._selectors;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Console.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Console.bindingEquals(this, obj);
        }

        public String toString() {
            return Console.bindingToString(this);
        }
    }
}

