/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Port;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.port.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.port.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class PortBuilder
implements Builder<Port> {
    private Config _config;
    private State _state;
    Map<Class<? extends Augmentation<Port>>, Augmentation<Port>> augmentation = Collections.emptyMap();

    public PortBuilder() {
    }

    public PortBuilder(Port base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Port>>, Augmentation<Port>>(aug);
        }
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public Config getConfig() {
        return this._config;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Port>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PortBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public PortBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public PortBuilder addAugmentation(Augmentation<Port> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Port>>, Augmentation<Port>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PortBuilder removeAugmentation(Class<? extends Augmentation<Port>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Port build() {
        return new PortImpl(this);
    }

    private static final class PortImpl
    extends AbstractAugmentable<Port>
    implements Port {
        private final Config _config;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PortImpl(PortBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Port.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Port.bindingEquals(this, obj);
        }

        public String toString() {
            return Port.bindingToString(this);
        }
    }
}

