/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.Connection;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.ConnectionKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.connection.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.connection.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.AuxiliaryId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class ConnectionBuilder
implements Builder<Connection> {
    private AuxiliaryId _auxId;
    private Config _config;
    private State _state;
    private ConnectionKey key;
    Map<Class<? extends Augmentation<Connection>>, Augmentation<Connection>> augmentation = Collections.emptyMap();

    public ConnectionBuilder() {
    }

    public ConnectionBuilder(Connection base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Connection>>, Augmentation<Connection>>(aug);
        }
        this.key = base.key();
        this._auxId = base.getAuxId();
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public ConnectionKey key() {
        return this.key;
    }

    public AuxiliaryId getAuxId() {
        return this._auxId;
    }

    public Config getConfig() {
        return this._config;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Connection>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConnectionBuilder withKey(ConnectionKey key) {
        this.key = key;
        return this;
    }

    public ConnectionBuilder setAuxId(AuxiliaryId value) {
        this._auxId = value;
        return this;
    }

    public ConnectionBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public ConnectionBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public ConnectionBuilder addAugmentation(Augmentation<Connection> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Connection>>, Augmentation<Connection>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConnectionBuilder removeAugmentation(Class<? extends Augmentation<Connection>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Connection build() {
        return new ConnectionImpl(this);
    }

    private static final class ConnectionImpl
    extends AbstractAugmentable<Connection>
    implements Connection {
        private final AuxiliaryId _auxId;
        private final Config _config;
        private final State _state;
        private final ConnectionKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConnectionImpl(ConnectionBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new ConnectionKey(base.getAuxId());
            this._auxId = this.key.getAuxId();
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public ConnectionKey key() {
            return this.key;
        }

        @Override
        public AuxiliaryId getAuxId() {
            return this._auxId;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Connection.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Connection.bindingEquals(this, obj);
        }

        public String toString() {
            return Connection.bindingToString(this);
        }
    }
}

