/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint64;

public class StateBuilder
implements Builder<State> {
    private Boolean _active;
    private String _description;
    private Uint64 _expirationDate;
    private Boolean _expired;
    private Boolean _inUse;
    private Uint64 _issueDate;
    private LicenseConfig.LicenseData _licenseData;
    private String _licenseId;
    private Boolean _valid;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }

    public StateBuilder(LicenseConfig arg) {
        this._licenseId = arg.getLicenseId();
        this._licenseData = arg.getLicenseData();
        this._active = arg.getActive();
    }

    public StateBuilder(LicenseState arg) {
        this._description = arg.getDescription();
        this._issueDate = arg.getIssueDate();
        this._expirationDate = arg.getExpirationDate();
        this._inUse = arg.getInUse();
        this._expired = arg.getExpired();
        this._valid = arg.getValid();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._active = base.getActive();
        this._description = base.getDescription();
        this._expirationDate = base.getExpirationDate();
        this._expired = base.getExpired();
        this._inUse = base.getInUse();
        this._issueDate = base.getIssueDate();
        this._licenseData = base.getLicenseData();
        this._licenseId = base.getLicenseId();
        this._valid = base.getValid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LicenseConfig) {
            this._licenseId = ((LicenseConfig)arg).getLicenseId();
            this._licenseData = ((LicenseConfig)arg).getLicenseData();
            this._active = ((LicenseConfig)arg).getActive();
            isValidArg = true;
        }
        if (arg instanceof LicenseState) {
            this._description = ((LicenseState)arg).getDescription();
            this._issueDate = ((LicenseState)arg).getIssueDate();
            this._expirationDate = ((LicenseState)arg).getExpirationDate();
            this._inUse = ((LicenseState)arg).getInUse();
            this._expired = ((LicenseState)arg).getExpired();
            this._valid = ((LicenseState)arg).getValid();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[LicenseConfig, LicenseState]");
    }

    public Boolean getActive() {
        return this._active;
    }

    public String getDescription() {
        return this._description;
    }

    public Uint64 getExpirationDate() {
        return this._expirationDate;
    }

    public Boolean getExpired() {
        return this._expired;
    }

    public Boolean getInUse() {
        return this._inUse;
    }

    public Uint64 getIssueDate() {
        return this._issueDate;
    }

    public LicenseConfig.LicenseData getLicenseData() {
        return this._licenseData;
    }

    public String getLicenseId() {
        return this._licenseId;
    }

    public Boolean getValid() {
        return this._valid;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setActive(Boolean value) {
        this._active = value;
        return this;
    }

    public StateBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public StateBuilder setExpirationDate(Uint64 value) {
        this._expirationDate = value;
        return this;
    }

    public StateBuilder setExpired(Boolean value) {
        this._expired = value;
        return this;
    }

    public StateBuilder setInUse(Boolean value) {
        this._inUse = value;
        return this;
    }

    public StateBuilder setIssueDate(Uint64 value) {
        this._issueDate = value;
        return this;
    }

    public StateBuilder setLicenseData(LicenseConfig.LicenseData value) {
        this._licenseData = value;
        return this;
    }

    public StateBuilder setLicenseId(String value) {
        this._licenseId = value;
        return this;
    }

    public StateBuilder setValid(Boolean value) {
        this._valid = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final Boolean _active;
        private final String _description;
        private final Uint64 _expirationDate;
        private final Boolean _expired;
        private final Boolean _inUse;
        private final Uint64 _issueDate;
        private final LicenseConfig.LicenseData _licenseData;
        private final String _licenseId;
        private final Boolean _valid;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._active = base.getActive();
            this._description = base.getDescription();
            this._expirationDate = base.getExpirationDate();
            this._expired = base.getExpired();
            this._inUse = base.getInUse();
            this._issueDate = base.getIssueDate();
            this._licenseData = base.getLicenseData();
            this._licenseId = base.getLicenseId();
            this._valid = base.getValid();
        }

        @Override
        public Boolean getActive() {
            return this._active;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public Uint64 getExpirationDate() {
            return this._expirationDate;
        }

        @Override
        public Boolean getExpired() {
            return this._expired;
        }

        @Override
        public Boolean getInUse() {
            return this._inUse;
        }

        @Override
        public Uint64 getIssueDate() {
            return this._issueDate;
        }

        @Override
        public LicenseConfig.LicenseData getLicenseData() {
            return this._licenseData;
        }

        @Override
        public String getLicenseId() {
            return this._licenseId;
        }

        @Override
        public Boolean getValid() {
            return this._valid;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

