/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.tacacs.server.top.tacacs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaTacacsServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.tacacs.server.top.tacacs.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.RoutingPassword;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder
implements Builder<Config> {
    private PortNumber _port;
    private RoutingPassword _secretKey;
    private CryptPasswordType _secretKeyHashed;
    private IpAddress _sourceAddress;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(AaaTacacsServerConfig arg) {
        this._port = arg.getPort();
        this._secretKey = arg.getSecretKey();
        this._secretKeyHashed = arg.getSecretKeyHashed();
        this._sourceAddress = arg.getSourceAddress();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._port = base.getPort();
        this._secretKey = base.getSecretKey();
        this._secretKeyHashed = base.getSecretKeyHashed();
        this._sourceAddress = base.getSourceAddress();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaTacacsServerConfig) {
            this._port = ((AaaTacacsServerConfig)arg).getPort();
            this._secretKey = ((AaaTacacsServerConfig)arg).getSecretKey();
            this._secretKeyHashed = ((AaaTacacsServerConfig)arg).getSecretKeyHashed();
            this._sourceAddress = ((AaaTacacsServerConfig)arg).getSourceAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[AaaTacacsServerConfig]");
    }

    public PortNumber getPort() {
        return this._port;
    }

    public RoutingPassword getSecretKey() {
        return this._secretKey;
    }

    public CryptPasswordType getSecretKeyHashed() {
        return this._secretKeyHashed;
    }

    public IpAddress getSourceAddress() {
        return this._sourceAddress;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public ConfigBuilder setSecretKey(RoutingPassword value) {
        this._secretKey = value;
        return this;
    }

    public ConfigBuilder setSecretKeyHashed(CryptPasswordType value) {
        this._secretKeyHashed = value;
        return this;
    }

    public ConfigBuilder setSourceAddress(IpAddress value) {
        this._sourceAddress = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final PortNumber _port;
        private final RoutingPassword _secretKey;
        private final CryptPasswordType _secretKeyHashed;
        private final IpAddress _sourceAddress;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._port = base.getPort();
            this._secretKey = base.getSecretKey();
            this._secretKeyHashed = base.getSecretKeyHashed();
            this._sourceAddress = base.getSourceAddress();
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public RoutingPassword getSecretKey() {
            return this._secretKey;
        }

        @Override
        public CryptPasswordType getSecretKeyHashed() {
            return this._secretKeyHashed;
        }

        @Override
        public IpAddress getSourceAddress() {
            return this._sourceAddress;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

