/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

public class StateBuilder
implements Builder<State> {
    private IpAddress _address;
    private Counter64 _connectionAborts;
    private Counter64 _connectionCloses;
    private Counter64 _connectionFailures;
    private Counter64 _connectionOpens;
    private Counter64 _connectionTimeouts;
    private Counter64 _errorsReceived;
    private Counter64 _messagesReceived;
    private Counter64 _messagesSent;
    private String _name;
    private Uint16 _timeout;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }

    public StateBuilder(AaaServerConfig arg) {
        this._name = arg.getName();
        this._address = arg.getAddress();
        this._timeout = arg.getTimeout();
    }

    public StateBuilder(AaaServerState arg) {
        this._connectionOpens = arg.getConnectionOpens();
        this._connectionCloses = arg.getConnectionCloses();
        this._connectionAborts = arg.getConnectionAborts();
        this._connectionFailures = arg.getConnectionFailures();
        this._connectionTimeouts = arg.getConnectionTimeouts();
        this._messagesSent = arg.getMessagesSent();
        this._messagesReceived = arg.getMessagesReceived();
        this._errorsReceived = arg.getErrorsReceived();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._address = base.getAddress();
        this._connectionAborts = base.getConnectionAborts();
        this._connectionCloses = base.getConnectionCloses();
        this._connectionFailures = base.getConnectionFailures();
        this._connectionOpens = base.getConnectionOpens();
        this._connectionTimeouts = base.getConnectionTimeouts();
        this._errorsReceived = base.getErrorsReceived();
        this._messagesReceived = base.getMessagesReceived();
        this._messagesSent = base.getMessagesSent();
        this._name = base.getName();
        this._timeout = base.getTimeout();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaServerState) {
            this._connectionOpens = ((AaaServerState)arg).getConnectionOpens();
            this._connectionCloses = ((AaaServerState)arg).getConnectionCloses();
            this._connectionAborts = ((AaaServerState)arg).getConnectionAborts();
            this._connectionFailures = ((AaaServerState)arg).getConnectionFailures();
            this._connectionTimeouts = ((AaaServerState)arg).getConnectionTimeouts();
            this._messagesSent = ((AaaServerState)arg).getMessagesSent();
            this._messagesReceived = ((AaaServerState)arg).getMessagesReceived();
            this._errorsReceived = ((AaaServerState)arg).getErrorsReceived();
            isValidArg = true;
        }
        if (arg instanceof AaaServerConfig) {
            this._name = ((AaaServerConfig)arg).getName();
            this._address = ((AaaServerConfig)arg).getAddress();
            this._timeout = ((AaaServerConfig)arg).getTimeout();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[AaaServerState, AaaServerConfig]");
    }

    public IpAddress getAddress() {
        return this._address;
    }

    public Counter64 getConnectionAborts() {
        return this._connectionAborts;
    }

    public Counter64 getConnectionCloses() {
        return this._connectionCloses;
    }

    public Counter64 getConnectionFailures() {
        return this._connectionFailures;
    }

    public Counter64 getConnectionOpens() {
        return this._connectionOpens;
    }

    public Counter64 getConnectionTimeouts() {
        return this._connectionTimeouts;
    }

    public Counter64 getErrorsReceived() {
        return this._errorsReceived;
    }

    public Counter64 getMessagesReceived() {
        return this._messagesReceived;
    }

    public Counter64 getMessagesSent() {
        return this._messagesSent;
    }

    public String getName() {
        return this._name;
    }

    public Uint16 getTimeout() {
        return this._timeout;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setAddress(IpAddress value) {
        this._address = value;
        return this;
    }

    public StateBuilder setConnectionAborts(Counter64 value) {
        this._connectionAborts = value;
        return this;
    }

    public StateBuilder setConnectionCloses(Counter64 value) {
        this._connectionCloses = value;
        return this;
    }

    public StateBuilder setConnectionFailures(Counter64 value) {
        this._connectionFailures = value;
        return this;
    }

    public StateBuilder setConnectionOpens(Counter64 value) {
        this._connectionOpens = value;
        return this;
    }

    public StateBuilder setConnectionTimeouts(Counter64 value) {
        this._connectionTimeouts = value;
        return this;
    }

    public StateBuilder setErrorsReceived(Counter64 value) {
        this._errorsReceived = value;
        return this;
    }

    public StateBuilder setMessagesReceived(Counter64 value) {
        this._messagesReceived = value;
        return this;
    }

    public StateBuilder setMessagesSent(Counter64 value) {
        this._messagesSent = value;
        return this;
    }

    public StateBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public StateBuilder setTimeout(Uint16 value) {
        this._timeout = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final IpAddress _address;
        private final Counter64 _connectionAborts;
        private final Counter64 _connectionCloses;
        private final Counter64 _connectionFailures;
        private final Counter64 _connectionOpens;
        private final Counter64 _connectionTimeouts;
        private final Counter64 _errorsReceived;
        private final Counter64 _messagesReceived;
        private final Counter64 _messagesSent;
        private final String _name;
        private final Uint16 _timeout;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._connectionAborts = base.getConnectionAborts();
            this._connectionCloses = base.getConnectionCloses();
            this._connectionFailures = base.getConnectionFailures();
            this._connectionOpens = base.getConnectionOpens();
            this._connectionTimeouts = base.getConnectionTimeouts();
            this._errorsReceived = base.getErrorsReceived();
            this._messagesReceived = base.getMessagesReceived();
            this._messagesSent = base.getMessagesSent();
            this._name = base.getName();
            this._timeout = base.getTimeout();
        }

        @Override
        public IpAddress getAddress() {
            return this._address;
        }

        @Override
        public Counter64 getConnectionAborts() {
            return this._connectionAborts;
        }

        @Override
        public Counter64 getConnectionCloses() {
            return this._connectionCloses;
        }

        @Override
        public Counter64 getConnectionFailures() {
            return this._connectionFailures;
        }

        @Override
        public Counter64 getConnectionOpens() {
            return this._connectionOpens;
        }

        @Override
        public Counter64 getConnectionTimeouts() {
            return this._connectionTimeouts;
        }

        @Override
        public Counter64 getErrorsReceived() {
            return this._errorsReceived;
        }

        @Override
        public Counter64 getMessagesReceived() {
            return this._messagesReceived;
        }

        @Override
        public Counter64 getMessagesSent() {
            return this._messagesSent;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Uint16 getTimeout() {
            return this._timeout;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

