/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.admin.top.admin.user;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAdminConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.admin.top.admin.user.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder
implements Builder<Config> {
    private String _adminPassword;
    private CryptPasswordType _adminPasswordHashed;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(AaaAdminConfig arg) {
        this._adminPassword = arg.getAdminPassword();
        this._adminPasswordHashed = arg.getAdminPasswordHashed();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._adminPassword = base.getAdminPassword();
        this._adminPasswordHashed = base.getAdminPasswordHashed();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaAdminConfig) {
            this._adminPassword = ((AaaAdminConfig)arg).getAdminPassword();
            this._adminPasswordHashed = ((AaaAdminConfig)arg).getAdminPasswordHashed();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[AaaAdminConfig]");
    }

    public String getAdminPassword() {
        return this._adminPassword;
    }

    public CryptPasswordType getAdminPasswordHashed() {
        return this._adminPasswordHashed;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setAdminPassword(String value) {
        this._adminPassword = value;
        return this;
    }

    public ConfigBuilder setAdminPasswordHashed(CryptPasswordType value) {
        this._adminPasswordHashed = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final String _adminPassword;
        private final CryptPasswordType _adminPasswordHashed;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._adminPassword = base.getAdminPassword();
            this._adminPasswordHashed = base.getAdminPasswordHashed();
        }

        @Override
        public String getAdminPassword() {
            return this._adminPassword;
        }

        @Override
        public CryptPasswordType getAdminPasswordHashed() {
            return this._adminPasswordHashed;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

