package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanMembersState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.Vlans;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.vlan.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.vlan.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configured VLANs keyed by id
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * list vlan {
 *   key vlan-id;
 *   leaf vlan-id {
 *     type leafref {
 *       path ../config/vlan-id;
 *     }
 *   }
 *   container config {
 *     uses vlan-config;
 *   }
 *   container state {
 *     config false;
 *     uses vlan-config;
 *     uses vlan-state;
 *   }
 *   uses vlan-members-state;
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-vlanvlan-topvlansvlan</i>
 *
 * <p>To create instances of this class use {@link VlanBuilder}.
 * @see VlanBuilder
 * @see VlanKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Vlan
    extends
    ChildOf<Vlans>,
    Augmentable<Vlan>,
    VlanMembersState,
    Identifiable<VlanKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.Vlan> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.Vlan.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.@NonNull Vlan obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getConfig());
        result = prime * result + Objects.hashCode(obj.getMembers());
        result = prime * result + Objects.hashCode(obj.getState());
        result = prime * result + Objects.hashCode(obj.getVlanId());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.@NonNull Vlan thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.Vlan other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.Vlan.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getVlanId(), other.getVlanId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConfig(), other.getConfig())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMembers(), other.getMembers())) {
            return false;
        }
        if (!Objects.equals(thisObj.getState(), other.getState())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.@NonNull Vlan obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Vlan");
        CodeHelpers.appendValue(helper, "config", obj.getConfig());
        CodeHelpers.appendValue(helper, "members", obj.getMembers());
        CodeHelpers.appendValue(helper, "state", obj.getState());
        CodeHelpers.appendValue(helper, "vlanId", obj.getVlanId());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    VlanKey key();
    
    /**
     * Return vlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         references the configured vlan-id
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} vlanId, or {@code null} if it is not present.
     *
     */
    VlanId getVlanId();
    
    /**
     * Return vlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         references the configured vlan-id
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} vlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if vlanId is not present
     *
     */
    default @NonNull VlanId requireVlanId() {
        return CodeHelpers.require(getVlanId(), "vlanid");
    }
    
    /**
     * Return config, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Configuration parameters for VLANs
     *     </code>
     * </pre>
     *
     * @return {@code Config} config, or {@code null} if it is not present.
     *
     */
    Config getConfig();
    
    /**
     * Return state, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         State variables for VLANs
     *     </code>
     * </pre>
     *
     * @return {@code State} state, or {@code null} if it is not present.
     *
     */
    State getState();

}

