package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.Vlan;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.VlanKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link VlansBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     VlansBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new VlansBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of VlansBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see VlansBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class VlansBuilder implements Builder<Vlans> {

    private Map<VlanKey, Vlan> _vlan;


    Map<Class<? extends Augmentation<Vlans>>, Augmentation<Vlans>> augmentation = Collections.emptyMap();

    public VlansBuilder() {
    }
    
    

    public VlansBuilder(Vlans base) {
        Map<Class<? extends Augmentation<Vlans>>, Augmentation<Vlans>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._vlan = base.getVlan();
    }


    public Map<VlanKey, Vlan> getVlan() {
        return _vlan;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Vlans>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public VlansBuilder setVlan(final Map<VlanKey, Vlan> values) {
        this._vlan = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public VlansBuilder addAugmentation(Augmentation<Vlans> augmentation) {
        Class<? extends Augmentation<Vlans>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public VlansBuilder removeAugmentation(Class<? extends Augmentation<Vlans>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Vlans build() {
        return new VlansImpl(this);
    }

    private static final class VlansImpl
        extends AbstractAugmentable<Vlans>
        implements Vlans {
    
        private final Map<VlanKey, Vlan> _vlan;
    
        VlansImpl(VlansBuilder base) {
            super(base.augmentation);
            this._vlan = CodeHelpers.emptyToNull(base.getVlan());
        }
    
        @Override
        public Map<VlanKey, Vlan> getVlan() {
            return _vlan;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Vlans.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Vlans.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Vlans.bindingToString(this);
        }
    }
}
