package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.outer.list.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.outer.list.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link DoubleTaggedOuterListBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DoubleTaggedOuterListBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new DoubleTaggedOuterListBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DoubleTaggedOuterListBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DoubleTaggedOuterListBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class DoubleTaggedOuterListBuilder implements Builder<DoubleTaggedOuterList> {

    private Config _config;
    private State _state;


    Map<Class<? extends Augmentation<DoubleTaggedOuterList>>, Augmentation<DoubleTaggedOuterList>> augmentation = Collections.emptyMap();

    public DoubleTaggedOuterListBuilder() {
    }
    
    

    public DoubleTaggedOuterListBuilder(DoubleTaggedOuterList base) {
        Map<Class<? extends Augmentation<DoubleTaggedOuterList>>, Augmentation<DoubleTaggedOuterList>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._config = base.getConfig();
        this._state = base.getState();
    }


    public Config getConfig() {
        return _config;
    }
    
    public State getState() {
        return _state;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DoubleTaggedOuterList>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public DoubleTaggedOuterListBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    public DoubleTaggedOuterListBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public DoubleTaggedOuterListBuilder addAugmentation(Augmentation<DoubleTaggedOuterList> augmentation) {
        Class<? extends Augmentation<DoubleTaggedOuterList>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public DoubleTaggedOuterListBuilder removeAugmentation(Class<? extends Augmentation<DoubleTaggedOuterList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DoubleTaggedOuterList build() {
        return new DoubleTaggedOuterListImpl(this);
    }

    private static final class DoubleTaggedOuterListImpl
        extends AbstractAugmentable<DoubleTaggedOuterList>
        implements DoubleTaggedOuterList {
    
        private final Config _config;
        private final State _state;
    
        DoubleTaggedOuterListImpl(DoubleTaggedOuterListBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._state = base.getState();
        }
    
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = DoubleTaggedOuterList.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return DoubleTaggedOuterList.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return DoubleTaggedOuterList.bindingToString(this);
        }
    }
}
