package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Specifies single-tagged packets with an exact VLAN identifier.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-single-tagged-config {
 *   leaf vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-vlanvlan-logical-single-tagged-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalSingleTaggedConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-logical-single-tagged-config");

    @Override
    Class<? extends VlanLogicalSingleTaggedConfig> implementedInterface();
    
    /**
     * Return vlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         VLAN identifier for single-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} vlanId, or {@code null} if it is not present.
     *
     */
    VlanId getVlanId();
    
    /**
     * Return vlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         VLAN identifier for single-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} vlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if vlanId is not present
     *
     */
    default @NonNull VlanId requireVlanId() {
        return CodeHelpers.require(getVlanId(), "vlanid");
    }

}

