package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Specifies double-tagged packets with an inner range and outer exact VLAN 
 * identifiers.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-double-tagged-inner-range-config {
 *   leaf inner-low-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf inner-high-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf-list outer-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-vlanvlan-logical-double-tagged-inner-range-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalDoubleTaggedInnerRangeConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-logical-double-tagged-inner-range-config");

    @Override
    Class<? extends VlanLogicalDoubleTaggedInnerRangeConfig> implementedInterface();
    
    /**
     * Return innerLowVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The low-value inner VLAN identifier in a range for double-tagged packets. The
     *         range is matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerLowVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getInnerLowVlanId();
    
    /**
     * Return innerLowVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The low-value inner VLAN identifier in a range for double-tagged packets. The
     *         range is matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerLowVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if innerLowVlanId is not present
     *
     */
    default @NonNull VlanId requireInnerLowVlanId() {
        return CodeHelpers.require(getInnerLowVlanId(), "innerlowvlanid");
    }
    
    /**
     * Return innerHighVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The high-value inner VLAN identifier in a range for double-tagged packets. The
     *         range is matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerHighVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getInnerHighVlanId();
    
    /**
     * Return innerHighVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The high-value inner VLAN identifier in a range for double-tagged packets. The
     *         range is matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerHighVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if innerHighVlanId is not present
     *
     */
    default @NonNull VlanId requireInnerHighVlanId() {
        return CodeHelpers.require(getInnerHighVlanId(), "innerhighvlanid");
    }
    
    /**
     * Return outerVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Outer VLAN identifier of double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code List<VlanId>} outerVlanId, or {@code null} if it is not present.
     *
     */
    @Nullable List<VlanId> getOuterVlanId();
    
    /**
     * Return outerVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Outer VLAN identifier of double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code List<VlanId>} outerVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if outerVlanId is not present
     *
     */
    default @NonNull List<VlanId> requireOuterVlanId() {
        return CodeHelpers.require(getOuterVlanId(), "outervlanid");
    }

}

