package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Specifies double-tagged packets with an inner range and an outer range of VLAN 
 * identifiers.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-double-tagged-inner-outer-range-config {
 *   leaf inner-low-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf inner-high-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf outer-low-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf outer-high-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-vlanvlan-logical-double-tagged-inner-outer-range-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalDoubleTaggedInnerOuterRangeConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-logical-double-tagged-inner-outer-range-config");

    @Override
    Class<? extends VlanLogicalDoubleTaggedInnerOuterRangeConfig> implementedInterface();
    
    /**
     * Return innerLowVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The low-value inner VLAN identifier in a range for double-tagged packets. The
     *         range is matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerLowVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getInnerLowVlanId();
    
    /**
     * Return innerLowVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The low-value inner VLAN identifier in a range for double-tagged packets. The
     *         range is matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerLowVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if innerLowVlanId is not present
     *
     */
    default @NonNull VlanId requireInnerLowVlanId() {
        return CodeHelpers.require(getInnerLowVlanId(), "innerlowvlanid");
    }
    
    /**
     * Return innerHighVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The high-value inner VLAN identifier in a range for double-tagged packets. The
     *         range is matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerHighVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getInnerHighVlanId();
    
    /**
     * Return innerHighVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The high-value inner VLAN identifier in a range for double-tagged packets. The
     *         range is matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerHighVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if innerHighVlanId is not present
     *
     */
    default @NonNull VlanId requireInnerHighVlanId() {
        return CodeHelpers.require(getInnerHighVlanId(), "innerhighvlanid");
    }
    
    /**
     * Return outerLowVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The low-value outer VLAN identifier in a range for double-tagged packets. The
     *         range is matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} outerLowVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getOuterLowVlanId();
    
    /**
     * Return outerLowVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The low-value outer VLAN identifier in a range for double-tagged packets. The
     *         range is matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} outerLowVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if outerLowVlanId is not present
     *
     */
    default @NonNull VlanId requireOuterLowVlanId() {
        return CodeHelpers.require(getOuterLowVlanId(), "outerlowvlanid");
    }
    
    /**
     * Return outerHighVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The high-value outer VLAN identifier for double-tagged packets. The range is
     *         matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} outerHighVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getOuterHighVlanId();
    
    /**
     * Return outerHighVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The high-value outer VLAN identifier for double-tagged packets. The range is
     *         matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} outerHighVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if outerHighVlanId is not present
     *
     */
    default @NonNull VlanId requireOuterHighVlanId() {
        return CodeHelpers.require(getOuterHighVlanId(), "outerhighvlanid");
    }

}

