package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.top.Vlan;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Subinterface1Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Subinterface1Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new Subinterface1BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Subinterface1Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Subinterface1Builder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class Subinterface1Builder implements Builder<Subinterface1> {

    private Vlan _vlan;



    public Subinterface1Builder() {
    }
    
    
    public Subinterface1Builder(VlanLogicalTop arg) {
        this._vlan = arg.getVlan();
    }

    public Subinterface1Builder(Subinterface1 base) {
        this._vlan = base.getVlan();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>VlanLogicalTop</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanLogicalTop) {
            this._vlan = ((VlanLogicalTop)arg).getVlan();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[VlanLogicalTop]");
    }

    public Vlan getVlan() {
        return _vlan;
    }

    
    public Subinterface1Builder setVlan(final Vlan value) {
        this._vlan = value;
        return this;
    }
    

    @Override
    public Subinterface1 build() {
        return new Subinterface1Impl(this);
    }

    private static final class Subinterface1Impl
        implements Subinterface1 {
    
        private final Vlan _vlan;
    
        Subinterface1Impl(Subinterface1Builder base) {
            this._vlan = base.getVlan();
        }
    
        @Override
        public Vlan getVlan() {
            return _vlan;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Subinterface1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Subinterface1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Subinterface1.bindingToString(this);
        }
    }
}
