package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.routed.top.RoutedVlan;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Interface1Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Interface1Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new Interface1BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Interface1Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Interface1Builder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class Interface1Builder implements Builder<Interface1> {

    private RoutedVlan _routedVlan;



    public Interface1Builder() {
    }
    
    
    public Interface1Builder(VlanRoutedTop arg) {
        this._routedVlan = arg.getRoutedVlan();
    }

    public Interface1Builder(Interface1 base) {
        this._routedVlan = base.getRoutedVlan();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>VlanRoutedTop</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanRoutedTop) {
            this._routedVlan = ((VlanRoutedTop)arg).getRoutedVlan();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[VlanRoutedTop]");
    }

    public RoutedVlan getRoutedVlan() {
        return _routedVlan;
    }

    
    public Interface1Builder setRoutedVlan(final RoutedVlan value) {
        this._routedVlan = value;
        return this;
    }
    

    @Override
    public Interface1 build() {
        return new Interface1Impl(this);
    }

    private static final class Interface1Impl
        implements Interface1 {
    
        private final RoutedVlan _routedVlan;
    
        Interface1Impl(Interface1Builder base) {
            this._routedVlan = base.getRoutedVlan();
        }
    
        @Override
        public RoutedVlan getRoutedVlan() {
            return _routedVlan;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Interface1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Interface1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Interface1.bindingToString(this);
        }
    }
}
