package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.ssh.server;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemSshServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.SshServer;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for the system ssh server
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-terminal</b>
 * <pre>
 * container config {
 *   uses system-ssh-server-config;
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-system-terminalsystem-ssh-server-topssh-serverconfig</i>
 *
 * <p>To create instances of this class use {@link ConfigBuilder}.
 * @see ConfigBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Config
    extends
    ChildOf<SshServer>,
    Augmentable<Config>,
    SystemSshServerConfig
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("config");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.ssh.server.Config> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.ssh.server.Config.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.ssh.server.@NonNull Config obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getEnable());
        result = prime * result + Objects.hashCode(obj.getProtocolVersion());
        result = prime * result + Objects.hashCode(obj.getRateLimit());
        result = prime * result + Objects.hashCode(obj.getSessionLimit());
        result = prime * result + Objects.hashCode(obj.getTimeout());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.ssh.server.@NonNull Config thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.ssh.server.Config other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.ssh.server.Config.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getEnable(), other.getEnable())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRateLimit(), other.getRateLimit())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSessionLimit(), other.getSessionLimit())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTimeout(), other.getTimeout())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProtocolVersion(), other.getProtocolVersion())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.ssh.server.@NonNull Config obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Config");
        CodeHelpers.appendValue(helper, "enable", obj.getEnable());
        CodeHelpers.appendValue(helper, "protocolVersion", obj.getProtocolVersion());
        CodeHelpers.appendValue(helper, "rateLimit", obj.getRateLimit());
        CodeHelpers.appendValue(helper, "sessionLimit", obj.getSessionLimit());
        CodeHelpers.appendValue(helper, "timeout", obj.getTimeout());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

