package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for system ssh configuration
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-terminal</b>
 * <pre>
 * grouping system-ssh-server-config {
 *   leaf enable {
 *     type boolean;
 *     default true;
 *   }
 *   leaf protocol-version {
 *     type enumeration {
 *       enum V2 {
 *       }
 *       enum V1 {
 *       }
 *       enum V1_V2 {
 *       }
 *     }
 *     default V2;
 *   }
 *   uses system-terminal-common-config;
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-system-terminalsystem-ssh-server-config</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemSshServerConfig
    extends
    DataObject,
    SystemTerminalCommonConfig
{


    @Generated("mdsal-binding-generator")
    public enum ProtocolVersion implements Enumeration {
        /**
         * Use SSH v2 only
         */
        V2(0, "V2"),
        
        /**
         * Use SSH v1 only
         */
        V1(1, "V1"),
        
        /**
         * Use either SSH v1 or v2
         */
        V1V2(2, "V1_V2")
        ;
    
        private static final Map<String, ProtocolVersion> NAME_MAP;
        private static final Map<Integer, ProtocolVersion> VALUE_MAP;
    
        static {
            final Builder<String, ProtocolVersion> nb = ImmutableMap.builder();
            final Builder<Integer, ProtocolVersion> vb = ImmutableMap.builder();
            for (ProtocolVersion enumItem : ProtocolVersion.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private ProtocolVersion(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding ProtocolVersion item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<ProtocolVersion> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding ProtocolVersion item, or null if no such item exists
         */
        public static ProtocolVersion forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-ssh-server-config");

    @Override
    Class<? extends SystemSshServerConfig> implementedInterface();
    
    /**
     * Return enable, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enables the ssh server. The ssh server is enabled by default.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enable, or {@code null} if it is not present.
     *
     */
    Boolean getEnable();
    
    /**
     * Return enable, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Enables the ssh server. The ssh server is enabled by default.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enable, guaranteed to be non-null.
     * @throws NoSuchElementException if enable is not present
     *
     */
    default @NonNull Boolean requireEnable() {
        return CodeHelpers.require(getEnable(), "enable");
    }
    
    /**
     * Return protocolVersion, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Set the protocol version for SSH connections to the system
     *     </code>
     * </pre>
     *
     * @return {@code ProtocolVersion} protocolVersion, or {@code null} if it is not present.
     *
     */
    ProtocolVersion getProtocolVersion();
    
    /**
     * Return protocolVersion, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Set the protocol version for SSH connections to the system
     *     </code>
     * </pre>
     *
     * @return {@code ProtocolVersion} protocolVersion, guaranteed to be non-null.
     * @throws NoSuchElementException if protocolVersion is not present
     *
     */
    default @NonNull ProtocolVersion requireProtocolVersion() {
        return CodeHelpers.require(getProtocolVersion(), "protocolversion");
    }

}

