package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpServerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.Server;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for an NTP server.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * container state {
 *   config false;
 *   uses system-ntp-server-config;
 *   uses system-ntp-server-state;
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-systemsystem-ntp-server-topserversserverstate</i>
 *
 * <p>To create instances of this class use {@link StateBuilder}.
 * @see StateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface State
    extends
    ChildOf<Server>,
    Augmentable<State>,
    SystemNtpServerConfig,
    SystemNtpServerState
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.State> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.State.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.@NonNull State obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAddress());
        result = prime * result + Objects.hashCode(obj.getAssociationType());
        result = prime * result + Objects.hashCode(obj.getIburst());
        result = prime * result + Objects.hashCode(obj.getOffset());
        result = prime * result + Objects.hashCode(obj.getPollInterval());
        result = prime * result + Objects.hashCode(obj.getPort());
        result = prime * result + Objects.hashCode(obj.getPrefer());
        result = prime * result + Objects.hashCode(obj.getRootDelay());
        result = prime * result + Objects.hashCode(obj.getRootDispersion());
        result = prime * result + Objects.hashCode(obj.getStratum());
        result = prime * result + Objects.hashCode(obj.getVersion());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.@NonNull State thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.State other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.State.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getIburst(), other.getIburst())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOffset(), other.getOffset())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPollInterval(), other.getPollInterval())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPort(), other.getPort())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPrefer(), other.getPrefer())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRootDelay(), other.getRootDelay())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRootDispersion(), other.getRootDispersion())) {
            return false;
        }
        if (!Objects.equals(thisObj.getStratum(), other.getStratum())) {
            return false;
        }
        if (!Objects.equals(thisObj.getVersion(), other.getVersion())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAddress(), other.getAddress())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAssociationType(), other.getAssociationType())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.@NonNull State obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("State");
        CodeHelpers.appendValue(helper, "address", obj.getAddress());
        CodeHelpers.appendValue(helper, "associationType", obj.getAssociationType());
        CodeHelpers.appendValue(helper, "iburst", obj.getIburst());
        CodeHelpers.appendValue(helper, "offset", obj.getOffset());
        CodeHelpers.appendValue(helper, "pollInterval", obj.getPollInterval());
        CodeHelpers.appendValue(helper, "port", obj.getPort());
        CodeHelpers.appendValue(helper, "prefer", obj.getPrefer());
        CodeHelpers.appendValue(helper, "rootDelay", obj.getRootDelay());
        CodeHelpers.appendValue(helper, "rootDispersion", obj.getRootDispersion());
        CodeHelpers.appendValue(helper, "stratum", obj.getStratum());
        CodeHelpers.appendValue(helper, "version", obj.getVersion());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

