package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.servers;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.Servers;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.servers.server.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.servers.server.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * List of the DNS servers that the resolver should query. When the resolver is 
 * invoked by a calling application, it sends the query to the first name server 
 * this list. If no response has been received within 'timeout' seconds, the 
 * resolver continues with the next server in the list. If no response is received 
 * from any server, the resolver continues with the first server again. When the 
 * resolver has traversed the list 'attempts' times without receiving any 
 * it gives up and returns an error to the calling application. Implementations 
 * limit the number of entries in this list.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * list server {
 *   key address;
 *   ordered-by user;
 *   leaf address {
 *     type leafref {
 *       path ../config/address;
 *     }
 *   }
 *   container config {
 *     uses system-dns-servers-config;
 *   }
 *   container state {
 *     config false;
 *     uses system-dns-servers-config;
 *     uses system-dns-servers-state;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-systemsystem-dns-servers-topserversserver</i>
 *
 * <p>To create instances of this class use {@link ServerBuilder}.
 * @see ServerBuilder
 * @see ServerKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Server
    extends
    ChildOf<Servers>,
    Augmentable<Server>,
    Identifiable<ServerKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("server");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.servers.Server> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.servers.Server.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.servers.@NonNull Server obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAddress());
        result = prime * result + Objects.hashCode(obj.getConfig());
        result = prime * result + Objects.hashCode(obj.getState());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.servers.@NonNull Server thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.servers.Server other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.servers.Server.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAddress(), other.getAddress())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConfig(), other.getConfig())) {
            return false;
        }
        if (!Objects.equals(thisObj.getState(), other.getState())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.servers.@NonNull Server obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Server");
        CodeHelpers.appendValue(helper, "address", obj.getAddress());
        CodeHelpers.appendValue(helper, "config", obj.getConfig());
        CodeHelpers.appendValue(helper, "state", obj.getState());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    ServerKey key();
    
    /**
     * Return address, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         References the configured address of the DNS server
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} address, or {@code null} if it is not present.
     *
     */
    IpAddress getAddress();
    
    /**
     * Return address, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         References the configured address of the DNS server
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} address, guaranteed to be non-null.
     * @throws NoSuchElementException if address is not present
     *
     */
    default @NonNull IpAddress requireAddress() {
        return CodeHelpers.require(getAddress(), "address");
    }
    
    /**
     * Return config, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Configuration data for each DNS resolver
     *     </code>
     * </pre>
     *
     * @return {@code Config} config, or {@code null} if it is not present.
     *
     */
    Config getConfig();
    
    /**
     * Return state, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Operational state data for each DNS resolver
     *     </code>
     * </pre>
     *
     * @return {@code State} state, or {@code null} if it is not present.
     *
     */
    State getState();

}

