package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.AvgMinMaxInstantStatsPct;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.MinMaxTime;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Percentage;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.StatInterval;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.StatIntervalState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link UserBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     UserBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new UserBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of UserBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see UserBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class UserBuilder implements Builder<User> {

    private Percentage _avg;
    private Percentage _instant;
    private StatInterval _interval;
    private Percentage _max;
    private Timeticks64 _maxTime;
    private Percentage _min;
    private Timeticks64 _minTime;


    Map<Class<? extends Augmentation<User>>, Augmentation<User>> augmentation = Collections.emptyMap();

    public UserBuilder() {
    }
    
    
    
    public UserBuilder(AvgMinMaxInstantStatsPct arg) {
        this._instant = arg.getInstant();
        this._avg = arg.getAvg();
        this._min = arg.getMin();
        this._max = arg.getMax();
        this._interval = arg.getInterval();
        this._minTime = arg.getMinTime();
        this._maxTime = arg.getMaxTime();
    }
    public UserBuilder(StatIntervalState arg) {
        this._interval = arg.getInterval();
    }
    public UserBuilder(MinMaxTime arg) {
        this._minTime = arg.getMinTime();
        this._maxTime = arg.getMaxTime();
    }

    public UserBuilder(User base) {
        Map<Class<? extends Augmentation<User>>, Augmentation<User>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._avg = base.getAvg();
        this._instant = base.getInstant();
        this._interval = base.getInterval();
        this._max = base.getMax();
        this._maxTime = base.getMaxTime();
        this._min = base.getMin();
        this._minTime = base.getMinTime();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>StatIntervalState</li>
     * <li>MinMaxTime</li>
     * <li>AvgMinMaxInstantStatsPct</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof StatIntervalState) {
            this._interval = ((StatIntervalState)arg).getInterval();
            isValidArg = true;
        }
        if (arg instanceof MinMaxTime) {
            this._minTime = ((MinMaxTime)arg).getMinTime();
            this._maxTime = ((MinMaxTime)arg).getMaxTime();
            isValidArg = true;
        }
        if (arg instanceof AvgMinMaxInstantStatsPct) {
            this._instant = ((AvgMinMaxInstantStatsPct)arg).getInstant();
            this._avg = ((AvgMinMaxInstantStatsPct)arg).getAvg();
            this._min = ((AvgMinMaxInstantStatsPct)arg).getMin();
            this._max = ((AvgMinMaxInstantStatsPct)arg).getMax();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[StatIntervalState, MinMaxTime, AvgMinMaxInstantStatsPct]");
    }

    public Percentage getAvg() {
        return _avg;
    }
    
    public Percentage getInstant() {
        return _instant;
    }
    
    public StatInterval getInterval() {
        return _interval;
    }
    
    public Percentage getMax() {
        return _max;
    }
    
    public Timeticks64 getMaxTime() {
        return _maxTime;
    }
    
    public Percentage getMin() {
        return _min;
    }
    
    public Timeticks64 getMinTime() {
        return _minTime;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<User>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public UserBuilder setAvg(final Percentage value) {
        this._avg = value;
        return this;
    }
    
    public UserBuilder setInstant(final Percentage value) {
        this._instant = value;
        return this;
    }
    
    public UserBuilder setInterval(final StatInterval value) {
        this._interval = value;
        return this;
    }
    
    public UserBuilder setMax(final Percentage value) {
        this._max = value;
        return this;
    }
    
    public UserBuilder setMaxTime(final Timeticks64 value) {
        this._maxTime = value;
        return this;
    }
    
    public UserBuilder setMin(final Percentage value) {
        this._min = value;
        return this;
    }
    
    public UserBuilder setMinTime(final Timeticks64 value) {
        this._minTime = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public UserBuilder addAugmentation(Augmentation<User> augmentation) {
        Class<? extends Augmentation<User>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public UserBuilder removeAugmentation(Class<? extends Augmentation<User>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public User build() {
        return new UserImpl(this);
    }

    private static final class UserImpl
        extends AbstractAugmentable<User>
        implements User {
    
        private final Percentage _avg;
        private final Percentage _instant;
        private final StatInterval _interval;
        private final Percentage _max;
        private final Timeticks64 _maxTime;
        private final Percentage _min;
        private final Timeticks64 _minTime;
    
        UserImpl(UserBuilder base) {
            super(base.augmentation);
            this._avg = base.getAvg();
            this._instant = base.getInstant();
            this._interval = base.getInterval();
            this._max = base.getMax();
            this._maxTime = base.getMaxTime();
            this._min = base.getMin();
            this._minTime = base.getMinTime();
        }
    
        @Override
        public Percentage getAvg() {
            return _avg;
        }
        
        @Override
        public Percentage getInstant() {
            return _instant;
        }
        
        @Override
        public StatInterval getInterval() {
            return _interval;
        }
        
        @Override
        public Percentage getMax() {
            return _max;
        }
        
        @Override
        public Timeticks64 getMaxTime() {
            return _maxTime;
        }
        
        @Override
        public Percentage getMin() {
            return _min;
        }
        
        @Override
        public Timeticks64 getMinTime() {
            return _minTime;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = User.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return User.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return User.bindingToString(this);
        }
    }
}
