package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.memory.top.Memory;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for system memory data definitions
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-memory-top {
 *   container memory {
 *     container config {
 *       uses system-memory-config;
 *     }
 *     container state {
 *       config false;
 *       uses system-memory-config;
 *       uses system-memory-state;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-systemsystem-memory-top</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemMemoryTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-memory-top");

    @Override
    Class<? extends SystemMemoryTop> implementedInterface();
    
    /**
     * Return memory, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for system memory data
     *     </code>
     * </pre>
     *
     * @return {@code Memory} memory, or {@code null} if it is not present.
     *
     */
    Memory getMemory();

}

