package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.top.Dns;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for DNS / resolver config and operational state data
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-dns-top {
 *   container dns {
 *     container config {
 *       uses system-dns-config;
 *     }
 *     container state {
 *       config false;
 *       uses system-dns-config;
 *       uses system-dns-state;
 *     }
 *     uses system-dns-servers-top;
 *     uses system-dns-static-top;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-systemsystem-dns-top</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemDnsTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-dns-top");

    @Override
    Class<? extends SystemDnsTop> implementedInterface();
    
    /**
     * Return dns, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for DNS resolver data
     *     </code>
     * </pre>
     *
     * @return {@code Dns} dns, or {@code null} if it is not present.
     *
     */
    Dns getDns();

}

