package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.process;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.ProcmonProcessAttributesState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.Process;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * State parameters related to monitored processes
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-procmon</b>
 * <pre>
 * container state {
 *   config false;
 *   uses procmon-process-attributes-state;
 * }
 * </pre>The schema path to identify an instance is
 * <i>openconfig-procmonprocmon-processes-topprocessesprocessstate</i>
 *
 * <p>To create instances of this class use {@link StateBuilder}.
 * @see StateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface State
    extends
    ChildOf<Process>,
    Augmentable<State>,
    ProcmonProcessAttributesState
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.process.State> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.process.State.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.process.@NonNull State obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getArgs());
        result = prime * result + Objects.hashCode(obj.getCpuUsageSystem());
        result = prime * result + Objects.hashCode(obj.getCpuUsageUser());
        result = prime * result + Objects.hashCode(obj.getCpuUtilization());
        result = prime * result + Objects.hashCode(obj.getMemoryUsage());
        result = prime * result + Objects.hashCode(obj.getMemoryUtilization());
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getPid());
        result = prime * result + Objects.hashCode(obj.getStartTime());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.process.@NonNull State thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.process.State other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.process.State.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getCpuUsageSystem(), other.getCpuUsageSystem())) {
            return false;
        }
        if (!Objects.equals(thisObj.getCpuUsageUser(), other.getCpuUsageUser())) {
            return false;
        }
        if (!Objects.equals(thisObj.getCpuUtilization(), other.getCpuUtilization())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMemoryUsage(), other.getMemoryUsage())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMemoryUtilization(), other.getMemoryUtilization())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPid(), other.getPid())) {
            return false;
        }
        if (!Objects.equals(thisObj.getStartTime(), other.getStartTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getArgs(), other.getArgs())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.process.@NonNull State obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("State");
        CodeHelpers.appendValue(helper, "args", obj.getArgs());
        CodeHelpers.appendValue(helper, "cpuUsageSystem", obj.getCpuUsageSystem());
        CodeHelpers.appendValue(helper, "cpuUsageUser", obj.getCpuUsageUser());
        CodeHelpers.appendValue(helper, "cpuUtilization", obj.getCpuUtilization());
        CodeHelpers.appendValue(helper, "memoryUsage", obj.getMemoryUsage());
        CodeHelpers.appendValue(helper, "memoryUtilization", obj.getMemoryUtilization());
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "pid", obj.getPid());
        CodeHelpers.appendValue(helper, "startTime", obj.getStartTime());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

